/*
 * File: RedCross.js
 * -----------------
 * The program draws a filled red cross that floats in a randomly
 * chosen direction.  Mouse clicks anywhere in the cross prompt it
 * to change directions.
 */
"use strict";

/* Constants */
const GWINDOW_WIDTH = 500;
const GWINDOW_HEIGHT = 300;
const CROSSBAR_LENGTH = 60;
const CROSSBAR_BREADTH = 20;
const TIME_STEP = 20;
const CROSS_SPEED = 2;

/* Main program */
function RedCross() {
	let gw = GWindow(GWINDOW_WIDTH, GWINDOW_HEIGHT);
	let cross = createRedCross(CROSSBAR_LENGTH, CROSSBAR_BREADTH);
	gw.add(cross, gw.getWidth()/2, gw.getHeight()/2);
	let direction = randomReal(0, 360);
	let step = function() {
		cross.movePolar(CROSS_SPEED, direction);
	};
	setInterval(step, TIME_STEP); // return value can be ignored
	let clickAction = function(e) {
		if (gw.getElementAt(e.getX(), e.getY()) === null) return;
		direction = randomReal(0, 360);
	};
	gw.addEventListener("click", clickAction);
}

/**
 * Function: createRedCross
 * ------------------------
 * Constructs and returns a GCompound consisting of two
 * red rectagles--the first wide by narrow pixels in size, the
 * second narrow by wide pixels in size--such that their centers
 * overlap. 
 */
function createRedCross(wide, narrow) {
	let cross = GCompound();
	cross.add(createFilledRectangle(wide, narrow, "Red"));
	cross.add(createFilledRectangle(narrow, wide, "Red"));
	return cross;
}

/**
 * Function: createFilledRectangle
 * -------------------------------
 * Constructs and returns a filled rectangle of the specified
 * width, height, and color (both border and fill).
 */
function createFilledRectangle(width, height, color) {
	let rect = GRect(-width/2, -height/2, width, height);
	rect.setFilled(true);
	rect.setColor(color);
	return rect;
}
