/*
 * File: Spoonerism.js
 * -------------------
 * Defines the spoonerism function according to the specifications
 * laid out in the first practice midterm.
 */

"use strict";

/* Main program */
function Spoonerism() {
	console.log('spoonerism("bunny rabbit") -> "' + spoonerism("bunny rabbit") + '"');
	console.log('spoonerism("take a shower") -> "' + spoonerism("take a shower") + '"');
	console.log('spoonerism("jelly beans") -> "' + spoonerism("jelly beans") + '"');
	console.log('spoonerism("crushing blow") -> "' + spoonerism("crushing blow") + '"');
	console.log('spoonerism("wash the dishes") -> "' + spoonerism("wash the dishes") + '"');
}

function spoonerism(phrase) {
	let sp1 = phrase.indexOf(' ');
	let sp2 = phrase.lastIndexOf(' ');
	let orig1 = phrase.substring(0, sp1);
	let orig2 = phrase.substring(sp2 + 1);
	let middle = phrase.substring(sp1, sp2 + 1);

	let vp1 = findFirstVowel(orig1);
	let vp2 = findFirstVowel(orig2);
	let transformed1 = orig2.substring(0, vp2) + orig1.substring(vp1);
	let transformed2 = orig1.substring(0, vp1) + orig2.substring(vp2);
	return transformed1 + middle + transformed2;
}

/**
 * Function: findFirstVowel
 * ------------------------
 * Returns the index of the first lowercase vowel, or -1 if no lowercase
 * vowel could be found.
 */
function findFirstVowel(str) {
	for (let i = 0; i < str.length; i++) {
		if (isEnglishVowel(str.charAt(i))) {
			return i;
		}
	}
}

/**
 * Function: isEnglishVowel
 * ------------------------
 * Returns true if and only if the provided string is of length 1, and
 * its one characters is a lowercase vowel.
 */
function isEnglishVowel(ch) {
	return ch.length === 1 && "aeiou".indexOf(ch) >= 0;
}
