/**
 * File: Leaders.js
 * ----------------
 * This file defines the leaders function and
 * simple test harness to confirm it really works.
 */

"use strict";

/**
 * Function: leaders
 * -----------------
 * Accepts an array of integers and returns a new array
 * containing that array's leaders.  The leaders are returned
 * in the order they appear in the original array.
 */
function leaders(array) {
	let result = [];
	for (let i = 0; i < array.length; i++) {
		let include = true;
		for (let j = i + 1; include && j < array.length; j++) {
			include = array[i] > array[j];
		}
		if (include) {
			result.push(array[i]);
		}
	}
	return result;
}

/**
 * Function: TestLeaders
 * ---------------------
 * Exercises the leaders function above.
 */
const TEST_CASES = [
	[6, 7, 4, 3, 5, 2],
	[9, 8, 7, 6, 5, 4, 3, 2, 1, 0],
	[1, 2, 3, 4, 5, 6],
	[]
];
function TestLeaders() {
	for (let i = 0; i < TEST_CASES.length; i++) {
		console.log("leaders([" + TEST_CASES[i] + "]) ---> [" + leaders(TEST_CASES[i]) + "]");
	}
}
