/**
 * File: Wumpus.js
 * ---------------
 * Defines the WUMPUS_CAVE constant and then
 * playerSmellsWumpus predicate function, along
 * with a small test harness to confirm everything
 * works as expected.
 */

"use strict";

const WUMPUS_CAVE = {
	playerLocation: 2,		// The player is in room 2
	wumpusLocation: 19,   // The wumpus is in room 19
	connections: [
		null, 							// room 0 is not used
		[6, 14, 16],				// room 1 connects to rooms 6, 14, and 16
		[3, 7, 18],					// room 2 connects to rooms 3, 7, and 18
		[2, 16, 20],				// room 3 connects to rooms 2, 16, and 20
		[6, 18, 19],				// and so forth
		[8, 9, 11],
		[1, 4, 15],
		[2, 12, 19],
		[5, 10, 13],
		[5, 11, 17],
		[8, 14, 16],
		[5, 9, 18],
		[7, 14, 16],
		[8, 15, 20],
		[1, 10, 12],
		[6, 12, 13],
		[1, 3, 10],
		[9, 19, 20],
		[2, 4, 11],
		[4, 17, 17],
		[3, 13, 17]
	]
};

/**
 * Predicate function: playerSmellsWumpus
 * --------------------------------------
 * Searches the cave just enough to decide whether
 * the player is within one or two rooms of the wumpus.
 * We assume the player and wumpus are guaranteed to be
 * in distinct rooms.
 *
 * It wasn't required of the problem statement, but this
 * version allows an optional second argument to be passed
 * in to be used in place of cave.playerLocation.  You didn't
 * need to support that with your own answer. :)
 */
function playerSmellsWumpus(cave, playerLocation) {
	let room = cave.playerLocation;
	if (playerLocation !== undefined) room = playerLocation;
	for (let i = 0; i < 3; i++) {
		let roomOneAway = cave.connections[room][i];
		if (roomOneAway === cave.wumpusLocation) return true;
		for (let j = 0; j < 3; j++) {
			let roomTwoAway = cave.connections[roomOneAway][j];
			if (roomTwoAway === cave.wumpusLocation) return true;
		}
	}
	return false;
}

/**
 * Function: Wumpus
 * ----------------
 * Simple test harness to ensure that playerSmellsWumpus
 * works properly.
 */
function Wumpus() {
	console.log("playerSmellsWumpus(WUMPUS_CAVE) --> " +
               playerSmellsWumpus(WUMPUS_CAVE));
	for (let room = 1; room < WUMPUS_CAVE.connections.length; room++) {
		console.log("playerSmellsWumpus(WUMPUS_CAVE, " + room + ") --> " +
	               playerSmellsWumpus(WUMPUS_CAVE, room));
	}
}
