/**
 * File: Fireworks.js
 * ------------------
 * The program animates the launch and explosion of a single firework,
 * as per the second problem statement in Practice Midterm 2.
 */

"use strict";

/* Constants (in pixels) */
const GWINDOW_WIDTH = 500;
const GWINDOW_HEIGHT = 300;
const DELTA_RADIUS = 2;

/* Constants (in milliseconds) */
const TIME_STEP = 20;
const FLIGHT_TIME = 1200;
const EXPANSION_TIME = 500;

/* Derived Constants */
const TOTAL_TIME = FLIGHT_TIME + EXPANSION_TIME; /* in milliseconds */
const NUM_STEPS = FLIGHT_TIME / TIME_STEP;

/* Main program */
function Fireworks() {
	let gw = GWindow(GWINDOW_WIDTH, GWINDOW_HEIGHT);
	let radius = 1;
	let firework = GOval(gw.getWidth()/2, gw.getHeight(),
		                 radius, radius);
	firework.setColor(randomColor());

	let targetx = randomReal(0, gw.getWidth());
	let targety = randomReal(0, gw.getHeight()/2);
	let dx = (targetx - firework.getX()) / NUM_STEPS;
	let dy = (targety - firework.getY()) / NUM_STEPS;

	let t = 0;
	gw.add(firework);
	let step = function() {
		if (t < FLIGHT_TIME) {
			firework.move(dx, dy);
		} else if (t < TOTAL_TIME) {
			radius += DELTA_RADIUS;
			firework.setBounds(firework.getX() - DELTA_RADIUS,
				               firework.getY() - DELTA_RADIUS,
				               2 * radius, 2 * radius);
		} else {
			clearInterval(timer);
		}

		t += TIME_STEP; // time advances no matter what happened
	}

	let timer = setInterval(step, TIME_STEP);
}
