/**
 * File: Portmanteau.js
 * --------------------
 * Defines the portmanteau function according to the specifications
 * laid out in the third problem of the second practice midterm.
 */

"use strict";

/* Main program */
function Portmanteau() {
	console.log('portmanteau("smoke", "fog") -> "' + portmanteau("smoke", "fog") + '"');
	console.log('portmanteau("tofu", "turkey") -> "' + portmanteau("tofu", "turkey") + '"');
	console.log('portmanteau("brad", "angelina") -> "' + portmanteau("brad", "angelina") + '"');
	console.log('portmanteau("spoon", "fork") -> "' + portmanteau("spoon", "fork") + '"');
	console.log('portmanteau("motor", "hotel") -> "' + portmanteau("motor", "hotel") + '"');
	console.log('portmanteau("frappé", "cappuccino") -> "' + portmanteau("frappé", "cappuccino") + '"');
}

function portmanteau(word1, word2) {
	let vp1 = findFirstVowel(word1);
	while (vp1 !== -1) {
		let vp2 = word2.indexOf(word1.charAt(vp1));
		if (vp2 >= 0) {
			return word1.substring(0, vp1) + word2.substring(vp2);
		}
		vp1 = findFirstVowel(word1, vp1 + 1);
	}
	return null;
}

/**
 * Function: findFirstVowel
 * ------------------------
 * Returns the index of the first lowercase vowel at or after the provided start position,
 * or -1 if no lowercase vowel could be found.  If the call to findFirstVowel omitted the
 * second parameter, then start is assumed to be 0.
 */
function findFirstVowel(word, start) {
	if (start === undefined) start = 0;
	for (let i = start; i < word.length; i++) {
		if (isEnglishVowel(word.charAt(i))) {
			return i;
		}
	}

	return -1;
}

/**
 * Function: isEnglishVowel
 * ------------------------
 * Returns true if and only if the provided string is of length 1, and
 * its one characters is a lowercase vowel.
 */
function isEnglishVowel(ch) {
	return ch.length === 1 && "aeiou".indexOf(ch) >= 0;
}
