/**
 * File: Dedupe.js
 * ---------------
 * Exports the dedupe function and provides a simple test harness to
 * ensure that implementation works.
 */

"use strict";

/**
 * Function: dedupe
 * ----------------
 * Updates the supplied array such that all duplicates
 * are removed.  The implementation is designed to work
 * for arrays of any single primitive type (e.g. an array
 * of numbers, or an array of strings, or an array of bools)
 */
function dedupe(array) {
	for (let i = array.length - 1; i >= 0; i--) {
		if (array.indexOf(array[i]) < i) {
			array.splice(i, 1);
		}
	}
	return array; // only here for convenience with console.log
                 // testing below, not expected in final exam answer
}

/**
 * Function: TestDedupe
 * --------------------
 * Exercises the dedupe function above.
 */
function TestDedupe() {
   console.log("dedupe([1, 1, 2, 1, 3, 2, 1, 4, 3, 2, 1, 5, 4, 3, 2, 1]) -> [" + dedupe([1, 1, 2, 1, 3, 2, 1, 4, 3, 2, 1, 5, 4, 3, 2, 1]) + "]");
   console.log("dedupe([]) -> [" + dedupe([]) + "]");
   console.log("dedupe([a, a, b, c, d, d, e, d, a]) -> [" + dedupe(["a", "a", "b", "c", "d", "d", "e", "d", "a"]) + "]");
}
