/*
 * File: ConsolePyramid.js
 * -----------------------
 * The program tests the function concatNCopies by drawing a pyramid
 * on the console.
 */

/* Constants */

const N_LEVELS = 10;
const BRICK_CHARACTER = "x";

/*
 * Draws a pyramid on the console.
 */

function ConsolePyramid() {
   for (let level = 1; level <= N_LEVELS; level++) {
      let spaces = concatNCopies(N_LEVELS - level, " ");
      let bricks = concatNCopies(2 * level - 1, BRICK_CHARACTER);
      console.log(spaces + bricks);
   }
}

/*
 * Creates a string consisting of n copies of str.
 */

function concatNCopies(n, str) {
   let result = "";
   for (let i = 0; i < n; i++) {
      result += str;
   }
   return result;
}
