/*
 * File: RuthAaronPairs.js
 * -----------------------
 * This program displays the first several Ruth-Aaron pairs, which
 * themselves are neighboring integers whose distinct prime factors happen
 * to sum up to the same value.  (714, 715) is such a pair, since 714's
 * prime factors are 2, 3, 7, and 17, 715's prime factors are 5, 11, and 13,
 * and 2 + 3 + 7 + 17 equals 5 + 11 + 13 equals 29.
 */

"use strict";

const NUM_PAIRS = 15;

/*
 * Function: RuthAaronPairs
 * ------------------------
 * Serves as the entry point for the entire program, which is to
 * print out, in iuncreasing order, the first NUM_PAIRS Ruth-Aaron pairs.
 */
function RuthAaronPairs() {
   introduce();
   printRuthAaronPairs();
}

/*
 * Function: introduce
 * -------------------
 * Unifies the text that needs to be printed at the beginning of execution
 * into a simple, well-named function.
 */
function introduce() {
   console.log("Here are the first " + NUM_PAIRS + " Ruth Aaron pairs:");
   console.log("");
}

/**
 * Function: printRuthAaronPairs
 * -----------------------------
 * Marches through the counting numbers and prints out
 * all the NUM_PAIRS Ruth-Aaron pairs of interest.  Every number
 * is considered in order, and those identified as the first of
 * a pair are printed out.  Provided we trust the implementation of
 * isRuthAaronNumber to return true or false as needed, the overall
 * narrative of printRuthAaronPairs is pretty clear.
 */
function printRuthAaronPairs() {
   let n = 1, numFound = 0;
   while (numFound < NUM_PAIRS) {
      if (isRuthAaronNumber(n)) {
         numFound++;
         console.log("  + (" + n + ", " + (n + 1) + ")");
      }
      n++;
   }
}

/**
 * Predicate: isRuthAaronNumber
 * ----------------------------
 * Returns true if and only if the supplied integer and its successor
 * comprise a Ruth-Aaron pair.  Note the reliance on the sumOfDistinctPrimes
 * function, which does virtually all of the legwork needed.
 */
function isRuthAaronNumber(n) {
   let first = n, second = n + 1;
   return sumOfDistinctPrimes(first) === sumOfDistinctPrimes(second);
}

/**
 * Function: sumOfDistinctPrimes
 * -----------------------------
 * Returns the sum of all of the distance prime numbers that perfectly
 * divide into n.  The algorithm below is very clever, so inline comments
 * are included to explain key parts.
 */
function sumOfDistinctPrimes(n) {
   let sum = 0, factor = 2; // 1 is not considered a prime number
   while (n > 1) {
      if (n % factor === 0) {
         sum += factor;      
         while (n % factor === 0) {
            n /= factor;
         } // while loop gets rid of all copies of factor, even though only one contributes to sum
      }
      factor++;
   }
   return sum;
}

