/*
 * File: DrawDots.js
 * -----------------
 * This program draws a dot every time the user clicks the mouse.
 */

/* Constants */
const GWINDOW_WIDTH = 500;
const GWINDOW_HEIGHT = 300;
const DOT_SIZE = 6;

/*
 * Draws a dot on the graphics window every time the user clicks the mouse.
 */
function DrawDots() {
  let gw = GWindow(GWINDOW_WIDTH, GWINDOW_HEIGHT);
  let clickAction = function(e) {
    let dot = GOval(e.getX() - DOT_SIZE / 2,
                    e.getY() - DOT_SIZE / 2,
                    DOT_SIZE, DOT_SIZE);
    dot.setFilled(true);
    gw.add(dot);
  };
  gw.addEventListener("click", clickAction);
 }
