/*
 * File: PacMan.js
 * ---------------
 * This program draws a picture of the PacMan video game character,
 * animating it so that it moves across the window opening and closing
 * its mouth.
 */

"use strict";

/* Constants */
const GWINDOW_WIDTH = 500;
const GWINDOW_HEIGHT = 300;
const TIME_STEP = 20;
const PACMAN_SIZE = 60;
const PACMAN_DX = 2;
const PACMAN_DTHETA = 5;

/* Main program */
function PacMan() {
   let gw = GWindow(GWINDOW_WIDTH, GWINDOW_HEIGHT);
   let x0 = 0;
   let y0 = (gw.getHeight() - PACMAN_SIZE)/2;
   let pacman = GArc(x0, y0, PACMAN_SIZE, PACMAN_SIZE, 45, 270);
   pacman.setFilled(true);
   pacman.setFillColor("Yellow");
   gw.add(pacman);
   let angle = 45;
   let sign = -1;
   let step = function() {
      angle += sign * PACMAN_DTHETA;
      if (angle === 0 || angle === 45) sign = -sign;
      pacman.setStartAngle(angle);
      pacman.setSweepAngle(360 - 2 * angle);
      pacman.move(PACMAN_DX, 0);
      if (pacman.getX() >= gw.getWidth() - PACMAN_SIZE) clearInterval(timer);
   };
   let timer = setInterval(step, TIME_STEP);
}
