/*
 * File: Stopwatch.js
 * ------------------
 * This program presents a simple animated stopwatch that can be started,
 * stopped, and continued by repeatedly clicking the mouse.
 */
"use strict";

/* Constants */
const GWINDOW_WIDTH = 500;
const GWINDOW_HEIGHT = 300;
const STOPWATCH_RADIUS = 80;
const STEP_TIME = 60000/360; // rotate 360 degrees over the course of 60 seconds
const DTHETA = 1;

/* Derived Constants */ 
const STOPWATCH_DIAMETER = 2 * STOPWATCH_RADIUS;
const STOPWATCH_HANDLENGTH = 0.8 * STOPWATCH_RADIUS;

function Stopwatch() {
   let gw = GWindow(GWINDOW_WIDTH, GWINDOW_HEIGHT);
	let stopwatch = createStopwatch();
	gw.add(stopwatch, GWINDOW_WIDTH/2, GWINDOW_HEIGHT/2);
	let timer = 0; // sentinel saying there's no timer
	let clickAction = function(e) {
		if (timer === 0) {
			let step = function() {
				stopwatch.rotate(-DTHETA);
			};
			timer = setInterval(step, STEP_TIME);
		} else {
			clearInterval(timer);
			timer = 0;
		}
	};
	gw.addEventListener("click", clickAction);
}

function createStopwatch() {
	let stopwatch = GCompound();
	stopwatch.add(GOval(-STOPWATCH_RADIUS, -STOPWATCH_RADIUS, STOPWATCH_DIAMETER, STOPWATCH_DIAMETER));
	stopwatch.add(GLine(0, 0, 0, -STOPWATCH_HANDLENGTH));		  
	return stopwatch;
}

