/*
 * File: MakeChange.js
 * -------------------
 * This file implements the makeChange function, which determines how to
 * make change for a particular number of cents.
 */

function MakeChange() {
   let amounts = [41, 75, 48, 70, 81, 99]
   for (let i = 0; i < amounts.length; i++) {
      console.log('makeChange(' + amounts[i] + ') -> ' + makeChange(amounts[i]));
   }
}

/* Constants */

const COIN_VALUES = [ 1, 5, 10, 25, 50, 100 ];
const COIN_NAMES = [
   "penny",
   "nickle",
   "dime",
   "quarter",
   "half-dollar",
   "dollar"
];

/*
 * Returns a string showing how to select coins that add to the
 * specified value of change.
 */
function makeChange(change) {
   let result = "";
   for (let i = COIN_VALUES.length - 1; i >= 0; i--) {
      let n = Math.floor(change/COIN_VALUES[i]);
      if (n > 0) {
         let noun = COIN_NAMES[i];
         if (n > 1) noun = createRegularPlural(noun);
         if (result.length > 0) result += ", ";
         result += n + " " + noun;
         change -= n * COIN_VALUES[i];
      }
   }
   return result;
}

/*
 * Creates the regular plural form of an English noun by applying the
 * following rules:
 *
 * - If the word ends in "s", "x", "z", "ch", or "sh", add "es" to the word.
 * - If the word ends in a "y" preceded by a consonant, change the y to "ies".
 * - In all other cases, just an "s".
 */
function createRegularPlural(word) {
   if (word.endsWith("s") || word.endsWith("x") ||  word.endsWith("z") ||
                             word.endsWith("ch") || word.endsWith("sh")) {
      return word + "es";
   } else if (word.endsWith("y") && word.length > 1 &&
              isEnglishConsonant(word.charAt(word.length - 2))) {
      return word.substring(0, word.length - 1) + "ies";
   } else {
      return word + "s";
   }
}

/*
 * Returns true if ch is an English consonant.
 */
function isEnglishConsonant(ch) {
   return isLetter(ch) && !isEnglishVowel(ch);
}

/*
 * Returns true if the character ch is a letter.
 */
function isLetter(ch) {
   return ch.length === 1 && ((ch >= "A" && ch <= "Z") ||
                              (ch >= "a" && ch <= "z"));
}

/*
 * Returns true if the character ch is a vowel (A, E, I, O, or U, in
 * either upper or lower case).
 */
function isEnglishVowel(ch) {
   return ch.length === 1 && "AEIOUaeiou".indexOf(ch) !== -1;
}
