/*
 * File: ReverseArray.js
 * ---------------------
 * This file exports the function reverseArray, which reverses the
 * elements of an array.
 */

function ReverseArray() {
   let array = createIndexArray(10);
   console.log("Forward: " + array);
   reverseArray(array);
   console.log("Reverse: " + array);
}

/*
 * Creates an array of length n in which each element contains its
 * own index.
 */
function createIndexArray(n) {
   let array = [];
   for (let i = 0; i < n; i++) {
      array.push(i);
   }
   return array;
}

/*
 * Reverses the elements in the array.  The change is reflected in the
 * argument array because it is passed as a reference and therefore
 * shares the same elements.
 */
function reverseArray(array) {
   for (let lh = 0; lh < array.length/2; lh++) {
      let rh = array.length - lh - 1;
      let tmp = array[lh];
      array[lh] = array[rh];
      array[rh] = tmp;
   }
}
