/*
 * File: UpperCase.js
 * ------------------
 * Provides the implementation of a toUpperCase function, which
 * accepts a string and returns the same string where all lowercase
 * letters have been replaced by their uppercase equivalents.
 * 
 * Note that you should use generally use String.toUpperCase() instead
 * of what we write here.  We're only pretending the method doesn't
 * exist so we have a small exercise to help understand String.charCodeAt
 * and String.fromCharCode.
 */
"use strict";

/**
 * Function: TestUpperCase
 * -----------------------
 * Provides a simple test harness for our toUpperCase function.
 */

const TEST_STRINGS = [
   "happy birthday!",
   "I tYpe LiKe ThIs.",
   "congratulations",
   "USA",
   "",
   ".",
   "a",
   "A"
];

function TestUpperCase() {
   for (let i = 0; i < TEST_STRINGS.length; i++) {
      console.log("toUpperCase(\"" + TEST_STRINGS[i] + "\") -> \"" + toUpperCase(TEST_STRINGS[i]) + "\"");
   }
}

/*
 * Function: toUpperCase
 * ---------------------
 * Accepts the provided string and returns the same string
 * where all alphabetic letters are uppercase.
 */
function toUpperCase(str) {
   let result = "";
   for (let i = 0; i < str.length; i++) {
      let ch = str.charAt(i);
      if (ch >= "a" && ch <= "z") {
         let offset = ch.charCodeAt(0) - "a".charCodeAt(0);
         ch = String.fromCharCode("A".charCodeAt(0) + offset);
      }
      result += ch;
   }
   return result;
}
