/*
 * File: LetterSubstitutionCipher.js
 * ---------------------------------
 * This file implements a function to encode a string using a
 * letter-substitution cipher.
 */

const KEY = "QWERTYUIOPASDFGHJKLZXCVBNM";

function LetterSubstitutionCipher() {
   console.log('encrypt("Et tu, Brute?", "QWERTYUIOPASDFGHJKLZXCVBNM") -> "' + encrypt("Et tu, Brute?", KEY) + '"');
   console.log('encrypt("Good luck tomorrow!", "QWERTYUIOPASDFGHJKLZXCVBNM") -> "' + encrypt("Good luck tomorrow!", KEY) + '"');
}

/*
 * Encrypts a string according to the key.  All letters in the string
 * are converted to uppercase.  Any character that is not a letter is
 * copied to the output unchanged.
 */
function encrypt(str, key) {
   let result = "";
   for (let i = 0; i < str.length; i++) {
      let ch = str.charAt(i);
      if (ch >= "A" && ch <= "Z") {
         let base = "A".charCodeAt(0);
         ch = key.charAt(ch.charCodeAt(0) - base);
      } else if (ch >= "a" && ch <= "z") {
         let base = "a".charCodeAt(0);
         ch = key.charAt(ch.charCodeAt(0) - base).toLowerCase();
      }
      result += ch;
   }
   return result;
}
