# File: CountLetterFrequencies.py

"""
This program counts the frequencies of letters in a sequence of lines
that the user enters on the console.
"""

def CountLetterFrequencies():
    counts = createFrequencyTable()
    print("Enter input lines, ending with a blank line.")
    while True:
        line = input()
        if line == "": break
        updateFrequencyTable(counts, line)
    printFrequencyTable(counts)

def createFrequencyTable():
    """
    Creates an empty frequency table, which is a list of 26 elements
    indicating the counts for each letter of the alphabet.
    """
    return [ 0 ] * 26

def updateFrequencyTable(counts, source):
    """
    Updates the frequency table by scanning the source string and
    recording the number of times each letter is encountered in
    the element of the counts array that corresponds to the index
    of the letter in the alphabet.
    """
    for ch in source:
        if ch.isalpha():
            counts[ord(ch.upper()) - ord("A")] += 1

def printFrequencyTable(counts):
    """
    Prints a frequency table using the data from counts, which is
    a 26-element array of integers, one for each letter.  Letters whose
    count is 0 are not included in the display.
    """
    for i in range(len(counts)):
        count = counts[i]
        if count > 0:
            ch = chr(ord("A") + i)
            print(ch + ": " + str(count))

# Startup code

if __name__ == "__main__":
    CountLetterFrequencies()
