# File: FindLongestLine.py

"""
This program finds the longest line in a file chosen by the user.
"""

from filechooser import chooseInputFile

def FindLongestLine():
    name = chooseInputFile()
    print("The longest line in the file is")
    print('"' + findLongestLine(name) + '"')

def findLongestLine(file):
    """
    Finds and returns the longest line in the specified file.
    """
    with open(file) as f:
        lines = f.read().splitlines()
    longest = ""
    for line in lines:
        if len(line) > len(longest):
            longest = line
    return longest     

# Startup code

if __name__ == "__main__":
    FindLongestLine()
