# File: FindLongestLineUsingFor.py

"""
This program finds the longest line in a file chosen by the user.
This version uses the file as an iterator and therefore returns the
newline as part of the line, which violates the caller's intuition.
"""

from filechooser import chooseInputFile

def FindLongestLine():
    name = chooseInputFile()
    print("The longest line in the file is")
    print('"' + findLongestLine(name) + '"')

def findLongestLine(file):
    """
    Finds and returns the longest line in the specified file.
    """
    longest = ""
    with open(file) as f:
        for line in f:
            if len(line) > len(longest):
                longest = line
    return longest     

# Startup code
if __name__ == "__main__":
    FindLongestLine()
