# File: Histogram.js

"""
This program reads a list of exam scores, with one score per line.
It then displays a histogram of those scores, divided into ranges
containing scores in the 00s, 10s, 20s, and so on, up to the range
containing only the value 100.
"""

from filechooser import chooseInputFile

# Main program 

def Histogram():
    filename = chooseInputFile()
    scores = [ ]
    with open(filename) as f:
        for line in f:
            scores.append(int(line.strip()))
    displayHistogram(createHistogram(scores))

# Helper function to create the histogram array 

def createHistogram(scores):
    histogram = [ 0 ] * 11
    for score in scores:
        if score >= 0 and score <= 100:
            range = score // 10
            histogram[range] += 1
    return histogram

# Helper function to display the histogram 

def displayHistogram(histogram):
    for i in range(0, 11):
        if i == 0:
            label = "00s: "
        elif i == 10:
            label = "100: "
        else:
            label = str(10 * i) + "s: "
        print(label + "*" * histogram[i])

# Startup code

if __name__ == "__main__":
    Histogram()
