# File: dictfile.py

"""
This module contains code to read a dictionary from a data file.
The data file contains key-value pairs listed on separate lines.
"""

def readDictionary(filename, separator=":"):
    """
    Creates a dictionary by reading key-value pairs from the
    specified file in which the division between the key and
    value is marked by the specified separator, which defaults
    to a colon.  The function discards any leading and trailing
    whitespace from both the key and the value.
    """
    dictionary = { }
    with open(filename) as f:
        for line in f:
            index = line.find(separator)
            key = line[:index].strip()
            value = line[index + len(separator):].strip()
            dictionary[key] = value
    return dictionary

