# File: PigLatin.py

"""
This file converts from English to Pig Latin using the following rules:
  1. If the word begins with a vowel, add "way" to the end of the word.
  2. If the word begins with a consonant, extract the leading consonants
     up to the first vowel, move them to the end, and then add "ay".
  3. If the word contains no vowels, return the word unchanged.
"""

from tokenscanner import TokenScanner

def toPigLatin(line):
    """
    Converts a multi-word string from English to Pig Latin.
    """
    result = ""
    scanner = TokenScanner(line)
    while scanner.hasMoreTokens():
        token = scanner.nextToken()
        if token.isalpha(): token = wordToPigLatin(token)
        result += token
    return result

def wordToPigLatin(word):
    """
    Translates a word to Pig Latin.
    """
    vp = findFirstVowel(word)
    if vp == -1:
        return word
    elif vp == 0:
        return word + "way"
    else:
        head = word[0:vp]
        tail = word[vp:]
        return tail + head + "ay"

def findFirstVowel(word):
    """
    Returns the index of the first vowel in the word, or -1 if none.
    """
    for i in range(len(word)):
        if isEnglishVowel(word[i]):
            return i
    return -1

def isEnglishVowel(ch):
    """
    Returns True if ch is an English vowel (A, E, I, O, or U).
    """
    return len(ch) == 1 and "AEIOUaeiou".find(ch) != -1

# Interactive test program 

def TestPigLatin():
    while True:
        line = input("Enter a string: ")
        if line == "": break
        print("Pig Latin form: " + toPigLatin(line))

# Startup code

if __name__ == "__main__":
    TestPigLatin();
