# File: RationalUnitTest.py

"""
This module implements a unit test of the Rational class.
"""

from rational import Rational
from unittest import UnitTest

# Constants 

ZERO = Rational(0)
ONE = Rational(1)
TWO = Rational(2)
ONE_HALF = Rational(1, 2)
ONE_THIRD = Rational(1, 3)
TWO_THIRDS = Rational(2, 3)
MINUS_ONE = Rational(-1)

def RationalUnitTest():
    UnitTest.resetErrorCount()
    testConstructor()
    testAdd()
    testSub()
    testMul()
    testDiv()
    testSumOfThree()
    testArithmeticOperators()
    testIntegerPromotion()
    testRelationalOperators()
    if UnitTest.getErrorCount() == 0:
        print("RationalUnitTest succeeded")
    else:
        print("RationalUnitTest failed")

# Test the Rational constructor 

def testConstructor():
    UnitTest.assertEquals(str(Rational(42)), "42")
    UnitTest.assertEquals(str(Rational(-17)), "-17")
    UnitTest.assertEquals(str(Rational(3, 1)), "3")
    UnitTest.assertEquals(str(Rational(1, 3)), "1/3")
    UnitTest.assertEquals(str(Rational(2, 6)), "1/3")
    UnitTest.assertEquals(str(Rational(-1, 3)), "-1/3")
    UnitTest.assertEquals(str(Rational(1, -3)), "-1/3")
    UnitTest.assertEquals(str(Rational(0, 2)), "0")

# Test the add method 

def testAdd():
    UnitTest.assertEquals(str(ONE.add(ONE)), "2")
    UnitTest.assertEquals(str(ONE_HALF.add(ONE_THIRD)), "5/6")
    UnitTest.assertEquals(str(ONE.add(MINUS_ONE)), "0")
    UnitTest.assertEquals(str(MINUS_ONE.add(ONE)), "0")

# Test the subtract method 

def testSub():
    UnitTest.assertEquals(str(ONE.sub(ONE)), "0")
    UnitTest.assertEquals(str(ONE_HALF.sub(ONE_THIRD)), "1/6")
    UnitTest.assertEquals(str(ONE.sub(MINUS_ONE)), "2")
    UnitTest.assertEquals(str(MINUS_ONE.sub(ONE)), "-2")

# Test the mul method 

def testMul():
    UnitTest.assertEquals(str(ZERO.mul(TWO)), "0")
    UnitTest.assertEquals(str(ONE_HALF.mul(ONE_THIRD)), "1/6")
    UnitTest.assertEquals(str(MINUS_ONE.mul(ONE_THIRD)), "-1/3")
    UnitTest.assertEquals(str(MINUS_ONE.mul(MINUS_ONE)), "1")

# Test the div method 

def testDiv():
    UnitTest.assertEquals(str(ZERO.div(TWO)), "0")
    UnitTest.assertEquals(str(ONE.div(TWO)), "1/2")
    UnitTest.assertEquals(str(TWO_THIRDS.div(ONE_THIRD)), "2")
    UnitTest.assertEquals(str(TWO.div(MINUS_ONE)), "-2")

def testSumOfThree():
    half = Rational(1, 2)
    third = Rational(1, 3)
    sixth = Rational(1, 6)
    sum = half + third + sixth
    UnitTest.assertEquals(str(sum), "1")

def testIntegerPromotion():
    UnitTest.assertEquals(1 + Rational(1, 2), Rational(3, 2))
    UnitTest.assertEquals(Rational(1, 3) - 1, Rational(-2, 3))

def testArithmeticOperators():
    UnitTest.assertTrue(Rational(1, 2) + Rational(1, 2) == 1)
    UnitTest.assertTrue(Rational(3, 4) - Rational(1, 2) == Rational(1, 4))
    UnitTest.assertTrue(Rational(2, 3) * Rational(1, 4) == Rational(1, 6))
    UnitTest.assertTrue(Rational(2, 3) / Rational(1, 2) == Rational(4, 3))
    UnitTest.assertTrue(Rational(-1, 2) + Rational(1, 2) == 0)
    UnitTest.assertTrue(Rational(-3, 4) - Rational(1, 2) == Rational(-5, 4))
    UnitTest.assertTrue(Rational(-2, 3) * Rational(1, 4) == Rational(-1, 6))
    UnitTest.assertTrue(Rational(-2, 3) / Rational(1, 2) == Rational(-4, 3))

def testRelationalOperators():
    UnitTest.assertTrue(Rational(0, 2) == Rational(0, 3))
    UnitTest.assertTrue(Rational(1, 2) == Rational(2, 4))
    UnitTest.assertTrue(Rational(1, 2) != Rational(3, 4))
    UnitTest.assertTrue(Rational(1, 2) < Rational(3, 4))
    UnitTest.assertTrue(Rational(1, 2) <= Rational(3, 4))
    UnitTest.assertTrue(Rational(1, 2) <= Rational(3, 6))
    UnitTest.assertFalse(Rational(1, 2) > Rational(3, 4))
    UnitTest.assertTrue(Rational(3, 4) > Rational(1, 2))
    UnitTest.assertTrue(Rational(3, 4) >= Rational(3, 4))
    UnitTest.assertTrue(Rational(3, 4) >= Rational(1, 2))
    UnitTest.assertTrue(Rational(1, 2) > 0)
    UnitTest.assertTrue(Rational(-1, 2) < 0)

# Startup code

if __name__ == "__main__":
    RationalUnitTest()
