/**
 * File: do-not-press.js
 * ---------------------
 * Provides the necessary Javascript needed to wire up the
 * event handling needed for the Do Not Press application.
 */
"use strict";

/**
 * Function: onButtonClick
 * -----------------------
 * Finds the div with an id of "digest" and programmatically
 * appends a new text node around "Do not press (etc)." followed by
 * a break tag.  All programmatically constructed HTML tags must
 * be created using document.createElement(tagName), where tagName is
 * the type of tag being created.  Free text can also be programmatically
 * introduced as well, but nodes around text must be created using
 * document.createTextNode(expr), where expr is an expression that evaluates
 * to a string.
 */
const WARNING = "Please do not press that button again!";
function onButtonClick(e) {
   let div = document.getElementById("digest");
   let textElement = document.createTextNode(WARNING);
   let breakTag = document.createElement("br");
   div.appendChild(textElement);
   div.appendChild(breakTag);
}

/*
 * The following code block is executed once the entire HTML
 * file has been parsed and the DOM has been fully constructed to
 * represent it.  Then, and only then, are we permitted to
 * search for elements by their ID
 */
document.addEventListener("DOMContentLoaded", function() {
   let button = document.getElementById("button");
   button.addEventListener("click", onButtonClick);
});