/*
 * File: main.cpp
 * --------------
 * Towers of Hanoi
 */

#include <iostream>
#include "console.h"
#include "stack.h"
using namespace std;

void towersOfHanoiThreeDisks(Stack<int>& destination) {
    Stack<int> source = {3, 2, 1};
    Stack<int> auxiliary;
    destination.push(source.pop());
    auxiliary.push(source.pop());
    auxiliary.push(destination.pop());
    destination.push(source.pop());
    source.push(auxiliary.pop());
    destination.push(auxiliary.pop());
    destination.push(source.pop());
}

int main() {
    Stack<int> result; // The final peg
    towersOfHanoiThreeDisks(result);
    cout << result << endl; // Show the final peg
    return 0;
}

/* Towers of Hanoi goal: Move the disk stack from the first peg (source)
 * to the last peg (destination)
 * - You can only move one disk at a time
 * - You cannot place a larger disk on top of a smaller disk
 * - Larger disks are represented by larger integers
 *
 * Use the provided 'source' and 'auxiliary' stacks to
 * populate the 'destination' stack that is passed in reference.
*/

// defines a stack with 1 on top, 2 in the middle, 3 on the bottom
/* FILL ME IN */


void towersOfHanoiGeneral(Stack<int>& destination, int numDisks) {
    // Populate source stack with numDisks initial disks
    Stack<int> source;
    for (int i = numDisks; i > 0; i--) {
        source.push(i);
    }
    Stack<int> auxiliary;
    /* CHALLENGE PROBLEM: FILL ME IN */
}

// Challenge problem: write a general towersOfHanoi function
// result = {};
// towersOfHanoiGeneral(result, 5);

