import random
from tqdm import tqdm

# getting close to infinity
n_trials = 10000000

def main():
    n_events = 0
    for i in tqdm(range(n_trials)):
        outcome = roll_dice()
        if is_event(outcome):
            n_events += 1
    pr_e = n_events / n_trials
    print(f'after {n_trials} trials')
    print('P(E) = ', pr_e)

def is_event(outcome):
    # was it a 6?
    return outcome == 6

def roll_dice():
    # give me a random dice roll
    # alternatively random.randint(1, 7)
    return random.choice([1,2,3,4,5,6])

if __name__ == '__main__':
    # this starts the program in main
    main()