#!/usr/bin/env python3

"""
Stanford CS106AP dict-count IP addr example
"""

import sys

"""
Every line in the file has an IP address

small-ips.txt looks like:

152.37.79.90
155.67.68.94
155.67.68.94
108.17.76.109
108.17.76.109
142.220.0.73
152.37.79.90
238.57.36.103

Try small-ips to start.
Can run with the big-ips.txt test file.

count_ips() - builds dict
print_counts() - prints out all ips
main() - puts above together
"""


def read_counts(filename):
    """
    Each line of the file contains an ip address.
    Build and return a counts dict, ip -> count
    >>> read_counts('small-ips.txt')
    {'152.37.79.90': 2, '155.67.68.94': 2, '108.17.76.109': 2, '142.220.0.73': 1, '238.57.36.103': 1}
    """
    counts = {}
    with open(filename) as f:
        for line in f:
            ip = line.strip()
            if ip not in counts:
                counts[ip] = 1
            else:
                counts[ip] += 1
    return counts




def print_counts(counts):
    """
    Given ip counts dict, print ips in alphabetical order
    on each line: ip count
    e.g.
    108.17.76.109 2
    142.220.0.73 1
    ...
    """
    for ip in sorted(counts.keys()):
        print(ip, counts[ip])
    # todo: could sort ip addrs numerically
    # convert each ip to a len-4 tuple of ints


def main():
    # main() is provided, calls count_ips() with filename
    args = sys.argv[1:]
    # args[0] is filename
    if len(args) == 1:
        counts = read_counts(args[0])
        print_counts(counts)


# Python boilerplate
if __name__ == '__main__':
    main()
