#!/usr/bin/env python3

"""
program1.py - a little python3 program to get started
Run from command line:
  $ python3 program1.py Abby

Triple quote is a string literal that
can span lines. Also a way to write big comments.
"""

import sys

EXCLAIM = '!'


def say_hello(name):
    """Print greeting to the given name."""
    suffix = ''
    if name == 'Abby':
        suffix = EXCLAIM
    elif name == 'Bob':
        suffix = EXCLAIM + EXCLAIM
    if name == 'Oops':
        name = no_such(name)
    print('Hello ' + name + suffix)


def main():
    args = sys.argv[1:]

    # print(args)   # see line args
    if len(args) >= 1:
         say_hello(args[0])


# Standard end-file boilerplate to call main().
if __name__ == '__main__':
    main()
