#!/usr/bin/env python3

"""
Stanford CS106AP dict-count IP addr example
"""

import sys

"""
Every line in the file has an IP address

small-ips.txt looks like:

152.37.79.90
155.67.68.94
155.67.68.94
108.17.76.109
108.17.76.109
142.220.0.73
152.37.79.90
238.57.36.103

When reading through line strings, use:
  ip = line.strip()
  
str.strip() function removes whitespace from front/end of string.
In this case, removes the \n from the end of line, so the ip
string is just the ip address chars.

Then run with the big-ips.txt test file.
"""


def count_ips(filename):
    """
    Each line of the file contains an ip address.
    1. Build a counts dict, ip -> count
    2. Then loop through the ips in sorted order
    and print each ip and its count on a line (example just below)
    *note* not "return" in this example, due to a Doctest quirk.

    A more decomposed design would be to return the dict, but for this
    simple example we just print it out.
    >>> count_ips('small-ips.txt')
    108.17.76.109 2
    142.220.0.73 1
    152.37.79.90 2
    155.67.68.94 2
    238.57.36.103 1
    """
    counts = {}
    with open(filename) as f:
        for line in f:
            # code TBD
            pass


def main():
    # main() is provided, calls count_ips() with filename
    args = sys.argv[1:]
    # args[0] is filename
    if len(args) == 1:
        count_ips(args[0])


# Python boilerplate
if __name__ == '__main__':
    main()
