#include<stdio.h>
//Program to compute all pairs shortest paths.


#define MAXVERTICES 100
#define INF 20
#define min(a,b) a<b?a:b


void FloydWarshall(int a[MAXVERTICES][MAXVERTICES],int numVertices);
 
int main(int argc,char **argv)
{
  int numVertices;
  int a[MAXVERTICES][MAXVERTICES];
  numVertices = acceptInput(argv[1],a);
  adjustMat(a,numVertices);
  FloydWarshall(a,numVertices);
  printMat(a,numVertices);


}


int adjustMat(int a[MAXVERTICES][MAXVERTICES],int numVertices)
{
  int i,j;
  for(i=0;i<numVertices;i++)
    {
      for(j=0;j<numVertices;j++)
	{
	  if(i==j)
	    a[i][j]=0;
	  else if(a[i][j]==0)
	    {
	      a[i][j]=INF;
	    }
	}
    }
   
}

void FloydWarshall(int a[MAXVERTICES][MAXVERTICES],int numVertices)
{
  int i,j,k;
  for(k=0;k<numVertices;k++)
    {
      for(i=0;i<numVertices;i++)
	{
	  for(j=0;j<numVertices;j++)
	    {
	      a[i][j] = min(a[i][j],a[i][k]+a[k][j]);
	    }
	}
    }
  
}




int acceptInput(char * fileName,int a[MAXVERTICES][MAXVERTICES])
{
  int i,j,numVertices;
  FILE *fp;
  fp = fopen(fileName,"r");

  if(fp == NULL)
    {
      printf("\n Invalid File Name");
      exit(0);
    }
  
  fscanf(fp,"%d",&numVertices);

  
  for(i=0;i<numVertices;i++)
    {
      for(j=0;j<numVertices;j++)
	{
	  fscanf(fp,"%d",&a[i][j]);
	}
    }
   return numVertices;
}

int printMat(int a[MAXVERTICES][MAXVERTICES],int numVertices)
{
   int i,j;
   for(i=0;i<numVertices;i++)
     {
       for(j=0;j<numVertices;j++)
	 {
	   printf("%d ",a[i][j]);
	 }
       printf("\n");
     }

}











