#include <stdlib.h>
#include <assert.h>
#include <stdio.h>

#define RADIUS 0.25
#define RADIUS2 RADIUS * RADIUS

double my_random()
{
  return (double)rand() / (double)RAND_MAX;
}

int rand_comp(const void* c1, const void* c2)
{
  if (*((int*)c1) == -666) return 1;
  if (*((int*)c2) == -666) return -1;
  return rand() - (RAND_MAX / 2);
}

void print_matrix(double* location_x, double* location_y, int total, int numgood,
		  FILE* outfile)
{
  int i, j, k, l;
  int realnodeperm[total+1];
  int *nodeperm = realnodeperm+1;

  realnodeperm[0] = -666;

  for(i = 0; i < total; i++)
  {
    printf("(%f,%f)\n", location_x[i], location_y[i]);
    for(j = 0; j < total; j++)
    {
      if (((location_x[i] - location_x[j]) * (location_x[i] - location_x[j]))
	  + ((location_x[i] - location_x[j]) * (location_x[i] - location_x[j]))
          < RADIUS2)
	fprintf(outfile,"1 ");
      else
	fprintf(outfile,"0 ");
    }
    fprintf(outfile, "\n");
  }
  printf("\n");
  fprintf(outfile, "\n");

  for(i = 0; i < numgood; i++)
  {

    k = 0;
    l = total-2;

    for(j = 0; j < total; j++)
    {
      if (j == i) continue;

      if (((location_x[i] - location_x[j]) * (location_x[i] - location_x[j]))
	  + ((location_x[i] - location_x[j]) * (location_x[i] - location_x[j]))
          < RADIUS2)
	nodeperm[k++] = j + 1;
      else
	nodeperm[l--] = j + 1;
    }
    //    fprintf(outfile,"%d %d %d %d\n", i, j, k, l);
    nodeperm[total-1] = i+1;

    //for(j = -1; j < total; j++)
    //  fprintf(outfile, "%d ", nodeperm[j]);
    //fprintf(outfile, "\n");

    //qsort(nodeperm, k, sizeof(int), rand_comp);
    //qsort(nodeperm+k, total-1-k, sizeof(int), rand_comp);

    for(j = 0; j < total; j++)
      fprintf(outfile, "%d ", nodeperm[j]);

    fprintf(outfile, "\n%d *\n", k);
  }
  fprintf(outfile, "\n");
}


int main(int argc, char ** argv)
{
  double location_x[100];
  double location_y[100];

  FILE *outfile;

  int num_good;
  int num_bad;
  int total;
  int i;
  int max_seq_no;
  int num_iterations;
  int node;

  assert(argc >= 6);
  srand(time(0));

  outfile = fopen(argv[1], "w");
  assert(outfile != NULL);

  num_good = atoi(argv[2]);
  num_bad = atoi(argv[3]);
  max_seq_no = atoi(argv[4]);
  num_iterations = atoi(argv[5]);

  fprintf(outfile, "%d %d %d %d *\n\n", num_good, num_bad, max_seq_no,
          num_iterations+1);

  total = num_good + num_bad;
  
  for(i = 0; i < total; i++)
  {
    location_x[i] = my_random();
    location_y[i] = my_random();
  }

  fprintf(outfile, "1 *\n");
  print_matrix(location_x, location_y, total, num_good, outfile);

  for(i = 0; i < num_iterations; i++)
  {
    node = total * my_random();
    location_x[node] = my_random();
    location_y[node] = my_random();

    fprintf(outfile, "%d *\n", node+1);
    print_matrix(location_x, location_y, total, num_good, outfile);
  }
}
