#!/usr/local/bin/perl
#
# Program generate topology specific part of the murphi file.
# 

sub mkmatrix {
    my($rows, $cols) = @_;
   # --$rows; --$cols;
    my $count = 1;
    my @mx = ();
    foreach (0 .. $rows) {
    my @row = ();
    $row[$_] = $count++ foreach (0 .. $cols);
    push(@mx, \@row);
    }
    return(\@mx);
}


sub printTopoInfo
{

    my ($myNumGood,$myNumBad,$myNumTopo,@mytopo) = @_;   
    
    $current_line=2;
    $totalNodes = $myNumGood + $myNumBad;

    for($j=1;$j<=$myNumTopo;$j++)
    {
        @t = split(/ /,$mytopo[$current_line]);
        print "\nmove_at[$j] := $t[0];" ;
        $current_line++;
	#read in the topology matrix
	for($k=1;$k<=$totalNodes;$k++)
	{
	    @temp = split(/ /,$mytopo[$current_line]);
	    for($l=1;$l<=$totalNodes;$l++)
	    {
		if($temp[$l-1] == 1)
		{
		    print "\ntopology[$j][$k][$l] := true;" ;
		    
		}
		else
		{
		    print "\ntopology[$j][$k][$l] := false;" ;
		}
	    }
	    $current_line++;
	    
	}
	$current_line++;
	#read in the speed dial stuff & and the size stuff and print it
	for($k=1;$k<=$myNumGood;$k++)
	{
	    @speed_list =split(/ /, $mytopo[$current_line]);
	    for($l=1;$l<=$totalNodes;$l++)
	    {
		print "\nspeed_dial_list[$j][$k][$l] := $speed_list[$l-1];"
	    }
	    $current_line++;
	    @speed_dial_size = split(/ /,$mytopo[$current_line]);
	   
	    print "\n speed_dial_size[$j][$k] := $speed_dial_size[0];";
	    $current_line++;
	    
	}
	$current_line++;
	
    }
    
    for($j=1;$j<=totalNodes;$j++)
    {
	print"turn_list[$j+1] := $j;";
    }

}


#opening the file
$input_file_name = $ARGV[0];
$topo_file_name = $ARGV[1];
open(INFILE, $input_file_name);		
open(TOPOFILE, $topo_file_name);		

@file = <INFILE>;
@topo = <TOPOFILE>;
close(INFILE);
close(TOPOFILE);


@numthings = split(/ /,($topo[0]));


$numGood = $numthings[0];
$numBad = $numthings[1];
$maxSeq = $numthings[2];
$numTopo = $numthings[3];




for($i=0;$i<=$#file;$i++)
{
    if($file[$i] =~ /%PRINTSTART/) 
    {
	
	printTopoInfo($numGood,$numBad,$numTopo,@topo);
    }	
    else
    {
	$file[$i]=~ s/%NUMGOODNODES/$numGood/g;
   	$file[$i]=~ s/%NUMBADNODES/$numBad/g;
   	$file[$i]=~ s/%MAXSEQUENCENUMBER/$maxSeq/g;
	$file[$i]=~ s/%NUMTOPOLOGIES/$numTopo/g;
	print $file[$i];
    }
	
}








