-----------------------------
--variables
-----------------------------

const
  --the tops
  NumTop:         %NUMTOPOLOGIES;

  --the good guys

  NumGoodNodes:    %NUMGOODNODES;

  --the bad guys
  NumBadNodes:     %NUMBADNODES;

  TotalNodes:      NumGoodNodes + NumBadNodes;

  MaxSequenceNumber:     %MAXSEQUENCENUMBER;
  MaxDistance:   NumGoodNodes + NumBadNodes;

type

  RouteRow : record
    sequence_no : 0..MaxSequenceNumber;
    distance:     0..MaxDistance;
    --next_hop_id : AgentId;
  end;

  RouteTable : array[1..TotalNodes] of RouteRow;

  TopVector : array[1..TotalNodes] of boolean;
  TopVectors : array[1..TotalNodes] of TopVector;

  SpeedDial : array[1..TotalNodes] of 1..TotalNodes;
SpeedDials : array[1..NumGoodNodes] of SpeedDial;

  SpeedSizes : array[1..NumGoodNodes] of 0..TotalNodes;

var
  routing_tables: array[1..TotalNodes] of RouteTable;
  topology: array[1..NumTop] of TopVectors;
  top_id: 1..NumTop;
  turn_list: array[1..TotalNodes] of 1..TotalNodes;
  turn: 1..TotalNodes;
  speed_dial_list: array[1..NumTop] of SpeedDials;
  speed_dial_size: array[1..NumTop] of SpeedSizes;
  speed_dial_index: array[1..NumGoodNodes] of 1..TotalNodes;
  speed_dial_index2: 1..TotalNodes;
  printout: 1..2;
  badAbout: 1..TotalNodes;
  move_at: array[1..NumTop] of 1..TotalNodes;
  change_top : boolean;

----------------------------
--rules
----------------------------


rule 0 "The topology changes"

  (top_id < NumTop) & (change_top)

  ==>
  begin

  top_id := top_id + 1;
  
  routing_tables[move_at[top_id]][move_at[top_id]].sequence_no := 
    routing_tables[move_at[top_id]][move_at[top_id]].sequence_no + 1;

  change_top := FALSE;

  printout := 1;
/*
  for i : 1..TotalNodes do
      if ((move_at[top_id] <= NumGoodNodes) & (topology[top_id][i][move_at[top_id]] = FALSE)) then
	routing_tables[move_at[top_id]][i].distance := TotalNodes;
      end;
  end;


  for i : 1..TotalNodes do
      if ((i <= NumGoodNodes) & (topology[top_id][i][move_at[top_id]] = FALSE)) then

	routing_tables[i][move_at[top_id]].distance := TotalNodes;

    end;
  end;
*/

for i : 1..NumGoodNodes do
      for j : 1..TotalNodes do

	if (topology[top_id][i][j] = FALSE) then
	  routing_tables[i][j].distance := TotalNodes;
        
	  end;
	end;
end;



end;



ruleset change: boolean do
rule 100 "A good node performs a broadcast update"

  (turn_list[turn] <= NumGoodNodes) &
  exists j: 1..TotalNodes do
    exists k: 1..TotalNodes do
      (topology[top_id][turn_list[turn]][j] = true) &
      ((routing_tables[turn_list[turn]][k].distance < (MaxDistance-1)) &   
      (((routing_tables[turn_list[turn]][k].sequence_no > routing_tables[j][k].sequence_no) |
       ((routing_tables[turn_list[turn]][k].sequence_no = routing_tables[j][k].sequence_no) &
	(routing_tables[turn_list[turn]][k].distance + 1 < routing_tables[j][k].distance)))))
    end
  end

  ==>
  begin

  for j: 1..TotalNodes do
    for k: 1..TotalNodes do

	  if (j != k) &
      ((topology[top_id][turn_list[turn]][j] = true) &
      ((routing_tables[turn_list[turn]][k].distance < (MaxDistance-1)) &   
      (((routing_tables[turn_list[turn]][k].sequence_no > routing_tables[j][k].sequence_no) |
       ((routing_tables[turn_list[turn]][k].sequence_no = routing_tables[j][k].sequence_no) &
	(routing_tables[turn_list[turn]][k].distance + 1 <
	routing_tables[j][k].distance)))))) then

        routing_tables[j][k].sequence_no := routing_tables[turn_list[turn]][k].sequence_no;
        routing_tables[j][k].distance := routing_tables[turn_list[turn]][k].distance + 1;
   
      end;

    end;
  end;

  turn := (turn % TotalNodes) + 1;

  change_top := change;

end;
end;

ruleset change: boolean do
rule 200 "Enable Printout"

  (top_id = NumTop) &
  (printout = 1) &

  forall i: 1..NumGoodNodes do
    forall j: 1..TotalNodes do
      forall k: 1..TotalNodes do

	((j != k) &
        ((routing_tables[i][k].distance < (MaxDistance-1)) &   
        ((topology[top_id][i][j] = true) & 
        ((routing_tables[i][k].sequence_no > routing_tables[j][k].sequence_no) |
	((routing_tables[i][k].sequence_no = routing_tables[j][k].sequence_no) &
	 (routing_tables[i][k].distance + 1 < routing_tables[j][k].distance))))))
      
      ->
      false
  
      end
    end
  end

  ==>
  begin

    printout := 2;
    change_top := change;

end;
end;

ruleset change: boolean do
rule 250 "Update turn if no good node moves"
  (turn_list[turn] <= NumGoodNodes)
  ==>
  begin
    turn := (turn % TotalNodes) + 1;
    change_top := change;
end;
end;

ruleset change: boolean do
ruleset new_seq_no: 0..MaxSequenceNumber do
  ruleset new_distance: 1..(MaxDistance-1) do
    rule 300 "A bad node performs a broadcast update about a single other node"
      
      (turn_list[turn] > NumGoodNodes)

    
    ==>
    begin

    for j: 1..TotalNodes do
      if  (j != badAbout) &
          ((topology[top_id][turn_list[turn]][j] = true) &
	  ((routing_tables[turn_list[turn]][badAbout].sequence_no > new_seq_no) |
           ((routing_tables[turn_list[turn]][badAbout].sequence_no = new_seq_no) &
           (routing_tables[turn_list[turn]][badAbout].distance + 1 <= new_distance))) &
	  ((routing_tables[j][badAbout].sequence_no < new_seq_no) |
           ((routing_tables[j][badAbout].sequence_no = new_seq_no) &
            (routing_tables[j][badAbout].distance > new_distance)))) then

       routing_tables[j][badAbout].sequence_no := new_seq_no;  
       routing_tables[j][badAbout].distance := new_distance;
       printout := 1;

      end;
    end;

    if (badAbout = TotalNodes) then 
      turn := (turn % TotalNodes) + 1;
      change_top := change;
    end;
    badAbout := (badAbout % TotalNodes) + 1;

  end;
  end;
end;
end;


------------------------------
--startstate
------------------------------

startstate
  for i:= 1 to TotalNodes do
    for j:= 1 to TotalNodes do
      routing_tables[i][j].sequence_no := 0; 
      routing_tables[i][j].distance := MaxDistance;
    end;
  end;

  for i:= 1 to TotalNodes do
    routing_tables[i][i].distance := 0;
  end;

  printout := 1;
  turn := 1;

  for i:= 1 to NumGoodNodes do
    speed_dial_index[i] := 1;
  end;
  speed_dial_index2 := 1;

top_id := 1;
badAbout := 1;

turn_list[1] := 1;
turn_list[2] := 2;
turn_list[3] := 3;
turn_list[4] := 4;

change_top := FALSE;

%PRINTSTART

end;
---------------------------------
-- invariants
---------------------------------

invariant "That is so true..."
  true;
--end;
