from random import *
from cs368lib import *

# Below are naive implementations that you can use to test gradescope
# Please replace with a more memory efficient implementation
# Any variables must be allocated through the API in cs368lib
# Unfortunately, this means many of the nice data structures in python
# (sets, dicts, etc) are not supported. If you find that you need these
# data structures, please post on piazza and I can add the support to the
# cs368lib.py file.
    
# Distinct element estimator
# ==========================
# Input: Stream of integers and an accuracy parameter epsilon
# Output: The number of distinct element in the stream up to multiplicative
# error epsilon. That is, return x such that 
#           (1-eps)||stream||_0 <= x <= (1+eps)||stream||_0
def f0_estimator(stream, eps):
    # TODO: Modify the code below to give the most memory efficient F0 estimator
    # that you can. Bonus points for topping the scoreboard!
    L = tracked_list()
    for s in stream:
        L.append(s)
    
    # Sort all the items and see how many times the values change
    xlast = tracked_int(L[0] - 1)
    f0 = tracked_int(0)
    L.sort()
    for s in L:
        if s != xlast:
            f0 += 1
            xlast = s
    
    return f0
        
# F2 estimator
# ============
# Input: Stream of integers and an accuracy parameter epsilon
# Output: The f2 norm of the stream up to error epsilon. That is, return x 
# such that 
#           (1-eps)||stream||_2 <= x <= (1+eps)||stream||_2
def f2_estimator(stream, eps):
    # TODO: Modify the code below to give the most memory efficient F2 estimator
    # that you can. Bonus points for topping the scoreboard!
    L = tracked_list()
    for s in stream:
        L.append(s)
    
    # Sort all the items and see how many times the values change
    xlast = tracked_int(L[0] - 1)
    f2 = tracked_int(0)
    cnt = tracked_int(0)
    L.sort()
    for s in L:
        if s != xlast:
            f2 += cnt * cnt
            xlast = s
            cnt = 0
        cnt += 1
        
    f2 += cnt * cnt
    return f2
    
# The part below is just for you to test your submission locally
# Try running python stream.py and see if you get the result you expect!
if __name__ == '__main__':
    # Here's a large random set that we can test distinct elements on
    maxR = 1234
    nL = 10000
    L = tracked_list(randint(1, maxR) for i in range(nL))
    print 'F0 estimate:', f0_estimator(L, 0.01)
    print 'F2 estimate:', f2_estimator(L, 0.01)
    
    # Here's how the judge will be estimating the memory in your submission
    # The memory reported here is from mem(L) + mem(f0_estimator) + mem(f2_estimator)
    print 'Total memory units used:', report_mem()
    