//*****************************************************************************
// File Name	: rprintftest.c
// 
// Title			: example usage of rprintf library functions
// Revision		: 1.0
// Notes			:	
// Target MCU	: Atmel AVR series
// Editor Tabs	: 3
// 
// Revision History:
// When			Who			Description of change
// -----------	-----------	-----------------------
// 10-Sep-2002	pstang		Created the program
//*****************************************************************************

 
//----- Include Files ---------------------------------------------------------
#include <io.h>			// include I/O definitions (port names, pin names, etc)
#include <sig-avr.h>		// include "signal" names (interrupt names)
#include <interrupt.h>	// include interrupt support

#include "global.h"		// include our global settings
#include "uart.h"			// include uart function library
#include "rprintf.h"		// include printf function library
#include "timer.h"		// include timer function library (timing, PWM, etc)
#include "vt100.h"

void rprintfTest(void);

//----- Begin Code ------------------------------------------------------------
int main(void)
{
	// initialize our libraries
	// initialize the UART (serial port)
	uartInit();
	// set the baud rate of the UART for our debug/reporting output
	uartSetBaudRate(9600);
	// set uartSendByte as the output for all rprintf statements
	rprintfInit(uartSendByte);
	// initialize the timer system
	timerInit();
	// initialize vt100 library
	vt100Init();
	vt100ClearScreen();
	// print a little intro messagLe so we know things are working
	rprintf("\r\nWelcome to rprintf Test!\r\n");

	// run the test function
	rprintfTest();

	//lcdInit();
	//rprintfInit(lcdDataWrite);

	// print single characters
	rprintfChar('H');
	rprintfChar('e');
	rprintfChar('l');
	rprintfChar('l');
	rprintfChar('o');
	// print a constant string stored in FLASH
	rprintfProgStrM(" World!");
	// print a carriage return, line feed combination
	rprintfCRLF();
	rprintf("\r\n");



	return 0;
}

void rprintfTest(void)
{
}

