#include "CDispRG.h"
#include "CDisp.h"

using namespace std;

FILE *inputfile;

CDispRG::CDispRG(Widget w, char *ifile, XInfo *xi) : CDisp(w, ifile, xi) 
{
	// the rg file is the famous Zebker amp file
	red = NULL ;
	grn = NULL ;
	both = NULL ;
	DispArr = 2 ;
	inputfile = fopen(ifile,"r");
}

int CDispRG::LoadArrays (unsigned char *r, unsigned char *g, int nsamps, int nlines) 
{
	// this function creates the arrays which are used to create the ximage arrays
	int i, j ;
	ns = nsamps ;
	nl = nlines ;
	//int byteorder;

	red = new unsigned char [ns * nl * 3] ;
	grn = new unsigned char [ns * nl * 3] ;
	both = new unsigned char [ns * nl * 3] ;
	ximage_red = XCreateImage (xinfo_ptr->dpy, xinfo_ptr->visual,
                xinfo_ptr->depth,
                ZPixmap, 0,
                (char *) red, ns, nl, 8, ns * 3) ; 
	ximage_grn = XCreateImage (xinfo_ptr->dpy, xinfo_ptr->visual,
                xinfo_ptr->depth,
                ZPixmap, 0,
                (char *) grn, ns, nl, 8, ns * 3) ; 
	ximage_both = XCreateImage (xinfo_ptr->dpy, xinfo_ptr->visual,
                xinfo_ptr->depth,
                ZPixmap, 0,
                (char *) both, ns, nl, 8, ns * 3) ; 
	ximage_red->bits_per_pixel=24 ;
	ximage_grn->bits_per_pixel=24 ;
	ximage_both->bits_per_pixel=24 ;

	//byteorder = ImageByteOrder(xinfo_ptr->dpy);
	//printf("byteorder, LSBFirst, MSBFirst = %d %d %d\n",byteorder,LSBFirst,MSBFirst);

	if(ImageByteOrder(xinfo_ptr->dpy) == LSBFirst){
	   for (i=0; i<nl; i++) {
		for (j=0; j<ns; j++) {
			*(red+i * ns * 3+j*3 +2) = *(r + i * ns + j) ; 
			*(red+i * ns * 3+j*3 +1) = 0 ;
			*(red+i * ns * 3+j*3 +0) = 0 ;
			*(grn+i * ns * 3+j*3 +2) = 0 ;
			*(grn+i * ns * 3+j*3 +1) = *(g + i * ns + j) ; 
			*(grn+i * ns * 3+j*3 +0) = 0 ;
			*(both+i * ns * 3+j*3+2) = *(r + i * ns + j) ;
			*(both+i * ns * 3+j*3 +1) = *(g + i * ns + j) ; 
			*(both+i * ns * 3+j*3 +0) = 0 ;
		}
	   }
	} else {
	   for (i=0; i<nl; i++) {
		for (j=0; j<ns; j++) {
			*(red+i * ns * 3+j*3 +0) = *(r + i * ns + j) ; 
			*(red+i * ns * 3+j*3 +1) = 0 ;
			*(red+i * ns * 3+j*3 +2) = 0 ;
			*(grn+i * ns * 3+j*3 +0) = 0 ;
			*(grn+i * ns * 3+j*3 +1) = *(g + i * ns + j) ; 
			*(grn+i * ns * 3+j*3 +2) = 0 ;
			*(both+i * ns * 3+j*3+0) = *(r + i * ns + j) ;
			*(both+i * ns * 3+j*3 +1) = *(g + i * ns + j) ; 
			*(both+i * ns * 3+j*3 +2) = 0 ;
		}
	   }
	}
	return (1) ;
}
			
 
int CDispRG::StartDisp() 
{
	int samps ;
	int lines ;
 

 
        samps = ns ;
        lines = nl ;
        XtVaSetValues (da, XmNwidth, samps, XmNheight, lines, NULL) ;
	if (pmap) XFreePixmap (xinfo_ptr->dpy, pmap) ;
        pmap = XCreatePixmap (xinfo_ptr->dpy, xinfo_ptr->rootwin, samps, lines, 24) ;
        XPutImage (xinfo_ptr->dpy, pmap, xinfo_ptr->imgGC, ximage_both, 0, 0, 0, 0, samps, lines) ;
 
        return (1) ;
}   
		

CDispRG::~CDispRG () {
	XDestroyImage (ximage_red) ;
	XDestroyImage (ximage_grn) ;
	XDestroyImage (ximage_both) ;
/*
	delete [] red ;
	delete [] grn ;
	delete [] both ;
*/
	if (pmap) XFreePixmap (xinfo_ptr->dpy, pmap) ;
	if (pmap_zm) XFreePixmap (xinfo_ptr->dpy, pmap_zm) ;
	pmap = 0 ;
	pmap_zm = 0 ;
}


void  CDispRG::expose_zm (Widget w, XtPointer xinfoeq, void *cbs)
{
        unsigned char *rgbzm, *iptr, *optr, *inarr=NULL ;
        int     ib, i, j, izm, jzm ;
        long    isamploc, osamploc ;
        XImage  *ximage_zm ;
 
        // using the zoom factor, the start coords, and the zoom window size
        XtVaGetValues (da_zm, XmNwidth, &zm_samps, XmNheight, &zm_lines, NULL) ;
        int fr_samps = zm_samps / zm_fac ;
        int fr_lines = zm_lines / zm_fac ;
 
 
        // allocate the memory for the data array to hold the zoomed memory
	if (DispArr == 0) inarr = red ;
	if (DispArr == 1) inarr = grn ;
	if (DispArr == 2) inarr = both ;
        rgbzm = new unsigned char [zm_samps * zm_lines * 3] ;
        for (i=0; i<fr_lines; i++) {
                for (j=0; j<fr_samps; j++) {
                        isamploc = (ystart + i) * ns * 3 + (xstart + j) * 3  ;
                        for (izm= 0; izm<zm_fac; izm++) {
                                for (jzm=0; jzm<zm_fac; jzm++) {
                                        osamploc = (i * zm_fac +  izm) * zm_samps * 3 +
                                                (j * 3* zm_fac + jzm * 3) ;
                                        for (ib=0; ib<3; ib++) {
                                                iptr = inarr + isamploc + ib ;
                                                optr = rgbzm + osamploc + ib ;
                                                *optr = *iptr ;
                                        }
                                }
                        }
                }
        }
        ximage_zm = XCreateImage (xinfo_ptr->dpy, xinfo_ptr->visual,
                xinfo_ptr->depth,
                ZPixmap, 0,
                (char *) rgbzm, zm_samps, zm_lines, 8, zm_samps * 3) ;
        ximage_zm->bits_per_pixel= 24 ;
        if (pmap_zm)
                XFreePixmap (xinfo_ptr->dpy, pmap_zm) ;
        pmap_zm = XCreatePixmap (xinfo_ptr->dpy, xinfo_ptr->rootwin, zm_samps, zm_lines, 24) ;
        XPutImage (xinfo_ptr->dpy, pmap_zm, xinfo_ptr->imgGC, ximage_zm, 0, 0, 0, 0,
                zm_samps, zm_lines) ;
        XCopyArea (xinfo_ptr->dpy, pmap_zm, XtWindow (w), xinfo_ptr->imgGC,
               0, 0, zm_samps, zm_lines, 0, 0) ;
        XDestroyImage (ximage_zm) ;
 
}                

void  CDispRG::click (Widget w, XtPointer xinfoeq, void *cbs)
{
        char cursbuf [80] ;
        int    xloc, yloc ;
	int    samps, lines ;
	int	xbuffer, ybuffer ;
        XmDrawingAreaCallbackStruct *dcbs ;

	float redvalue[1],grnvalue[1];

        dcbs = (XmDrawingAreaCallbackStruct *) cbs ;
        XEvent  *event =  dcbs->event ;
        xloc = event->xbutton.x ;
        yloc = event->xbutton.y ;

	samps = ns ;
	lines = nl ;

	if (event->xany.type==ButtonPress) return ;
	if (event->xbutton.button==3) {
		DispArr++ ; 
		if (DispArr > 2) DispArr = 0 ; 
		switch (DispArr) {
		    case 0 :
			XPutImage (xinfo_ptr->dpy, pmap, xinfo_ptr->imgGC, ximage_red, 0, 0, 0, 0,
                		samps, lines) ; 
			break ;
		    case 1 :
			XPutImage (xinfo_ptr->dpy, pmap, xinfo_ptr->imgGC, ximage_grn, 0, 0, 0, 0,
                		samps, lines) ; 
			break ;
		    case 2 :
			XPutImage (xinfo_ptr->dpy, pmap, xinfo_ptr->imgGC, ximage_both, 0, 0, 0, 0,
                		samps, lines) ; 
			break ;
		}
        	XClearArea (xinfo_ptr->dpy, XtWindow (da), 0, 0, 0, 0, True) ;
	}
 
	//cout << "xloc  yloc : " << xloc << "  " << yloc << endl ;
        //sprintf (cursbuf, "X :   %5d      Y :    %5d", xloc, yloc) ;

        fseek ( inputfile, yloc*samps*8+xloc*4, SEEK_SET);
        fread (redvalue,4,1,inputfile);
        fseek ( inputfile, yloc*samps*8+xloc*4+4, SEEK_SET);
        fread (grnvalue,4,1,inputfile);

        printf ("xloc  yloc : %d %d, Red, Grn: %f %f\n",xloc,yloc, redvalue[0], grnvalue[0]); 
        sprintf (cursbuf, "X, Y: %5d %5d  Red, Grn: %f %f", xloc, yloc, redvalue[0], grnvalue[0
		 ]) ;


        XmTextSetString (xinfo_ptr->curswin, cursbuf) ;
        XtVaGetValues (da_zm, XmNwidth, &zm_samps, XmNheight, &zm_lines, NULL) ;
        xstart = xloc - zm_samps / zm_fac / 2 ;
        ystart = yloc - zm_samps / zm_fac / 2 ;
	xbuffer = zm_samps / zm_fac  ;
        ybuffer = zm_lines / zm_fac  ;
        xstart = (xstart<0) ? 0:xstart ;
        xstart = (xstart>ns - xbuffer-1) ? ns - xbuffer-1 : xstart ;
        ystart = (ystart<0) ? 0:ystart ;
        ystart = (ystart>nl - ybuffer-1) ? nl - ybuffer-1 : ystart ; 
	cout << "Xstart :    Ystart : " << xstart << "  " << ystart << endl ;
        XClearArea (xinfo_ptr->dpy, XtWindow (da_zm), 0, 0, 0, 0, True) ;

	 
 
}    
 
void CDispRG::click_da (Widget w, XtPointer xinfoeq, void *cbs)
{
        CDispRG *thisptr = (CDispRG *) xinfoeq ;
        thisptr->click (w, xinfoeq, cbs) ;
}             

void CDispRG::expose_dazm (Widget w, XtPointer xinfoeq, void *cbs)
{
        CDispRG *thisptr = (CDispRG *) xinfoeq ;
        thisptr->expose_zm (w, xinfoeq, cbs) ;
}
 
/*
void CDisp::expose_da (Widget w, XtPointer xinfoeq, void *cbs)
{
        CDispRG *thisptr = (CDispRG *) xinfoeq ;
        thisptr->expose (w, xinfoeq, cbs) ;
}
*/
/*
void CDispRG::resize_da (Widget w, XtPointer xinfoeq, void *cbs)
{
        CDisp *thisptr = (CDisp *) xinfoeq ;
        thisptr->resize (w, xinfoeq, cbs) ;
}
*/
