#include "CDispShort.h"

FILE *cdispmaginputfile;

CDispShort::CDispShort (Widget w, char *ifile, XInfo *xi) :CDisp(w, ifile, xi) {
	mag=NULL ;

	cdispmaginputfile = fopen(ifile,"r");

}

CDispShort::~CDispShort () 
{
	if (ximage_mag) XDestroyImage (ximage_mag) ;
	rgb = NULL ;
}

int CDispShort::LoadArray(unsigned char *magarr, int nsamps, int nlines) {
	 int i, j ;
        ns = nsamps ;
        nl = nlines ;
 
        mag= new unsigned char [ns * nl * 3] ;
        ximage_mag = XCreateImage (xinfo_ptr->dpy, xinfo_ptr->visual,
                xinfo_ptr->depth,
                ZPixmap, 0,
                (char *) mag, ns, nl, 8, ns * 3) ;
        ximage_mag->bits_per_pixel=24 ;
 
        for (i=0; i<nl; i++) {
                for (j=0; j<ns; j++) {
                        *(mag+i * ns * 3+j*3+0) = *(magarr + i * ns + j) ;
                        *(mag+i * ns * 3+j*3 +1) = *(magarr + i * ns + j) ;
                        *(mag+i * ns * 3+j*3 +2) = *(magarr + i * ns + j) ;
                }
        }
        return (1) ;
}                

int CDispShort::WriteArray(unsigned char *magarr, int nsamps, int nlines) {
	 int i, j ;
        ns = nsamps ;
        nl = nlines ;
	FILE *Of;
 
        mag= new unsigned char [ns * nl * 3] ;
        ximage_mag = XCreateImage (xinfo_ptr->dpy, xinfo_ptr->visual,
                xinfo_ptr->depth,
                ZPixmap, 0,
                (char *) mag, ns, nl, 8, ns * 3) ;
        ximage_mag->bits_per_pixel=24 ;
 
        for (i=0; i<nl; i++) {
                for (j=0; j<ns; j++) {
                        *(mag+i * ns * 3+j*3+0) = *(magarr + i * ns + j) ;
                        *(mag+i * ns * 3+j*3 +1) = *(magarr + i * ns + j) ;
                        *(mag+i * ns * 3+j*3 +2) = *(magarr + i * ns + j) ;
                }
        }

        //write to disk - raw bytes
        Of = fopen("dismag.dat","w") ;
        if (Of == NULL){
            fprintf(stderr, "file open problem!\n");
            return(1);
        }
        fwrite((char *)magarr, sizeof(char), nl*ns, Of) ;
        fclose(Of);
                                                                               
        Of = fopen("dismag.ppm","w") ;
        if (Of == NULL){
            fprintf(stderr, "file open problem!\n");
            return(1);
        }
        fprintf(Of,"P6 %d %d 255\n",ns,nl);
        fwrite((char *)mag, sizeof(char), nl*ns*3, Of) ;
        fclose(Of);
                                                                               
        return (1) ;
}                

int CDispShort::StartDisp () 
{
        int samps ;
        int lines ;
 
 
 
        samps = ns ;
        lines = nl ;
        XtVaSetValues (da, XmNwidth, samps, XmNheight, lines, NULL) ;
        if (pmap) XFreePixmap (xinfo_ptr->dpy, pmap) ;
        pmap = XCreatePixmap (xinfo_ptr->dpy, xinfo_ptr->rootwin, samps, lines, 24) ;
        XPutImage (xinfo_ptr->dpy, pmap, xinfo_ptr->imgGC, ximage_mag, 0, 0, 0, 0, samps, lines) ;
 
        return (1) ;
}                                                                                                                      
void  CDispShort::expose_zm (Widget w, XtPointer xinfoeq, void *cbs)
{
        unsigned char *rgbzm, *iptr, *optr, *inarr ;
        int     ib, i, j, izm, jzm ;
        long    isamploc, osamploc ;
        XImage  *ximage_zm ;
 
        // using the zoom factor, the start coords, and the zoom window size
        XtVaGetValues (da_zm, XmNwidth, &zm_samps, XmNheight, &zm_lines, NULL) ;
        int fr_samps = zm_samps / zm_fac ;
        int fr_lines = zm_lines / zm_fac ;
 
 
        // allocate the memory for the data array to hold the zoomed memory
        inarr = mag ;
        rgbzm = new unsigned char [zm_samps * zm_lines * 3] ;
        for (i=0; i<fr_lines; i++) {
                for (j=0; j<fr_samps; j++) {
                        isamploc = (ystart + i) * ns * 3 + (xstart + j) * 3  ;
                        for (izm= 0; izm<zm_fac; izm++) {
                                for (jzm=0; jzm<zm_fac; jzm++) {
                                        osamploc = (i * zm_fac +  izm) * zm_samps * 3 +
                                                (j * 3* zm_fac + jzm * 3) ;
                                        for (ib=0; ib<3; ib++) {
                                                iptr = inarr + isamploc + ib ;
                                                optr = rgbzm + osamploc + ib ;
                                                *optr = *iptr ;
                                        }
                                }
                        }
                }
        }
        ximage_zm = XCreateImage (xinfo_ptr->dpy, xinfo_ptr->visual,
                xinfo_ptr->depth,
                ZPixmap, 0,
                (char *) rgbzm, zm_samps, zm_lines, 8, zm_samps * 3) ;
        ximage_zm->bits_per_pixel= 24 ;
        if (pmap_zm)
                XFreePixmap (xinfo_ptr->dpy, pmap_zm) ;
        pmap_zm = XCreatePixmap (xinfo_ptr->dpy, xinfo_ptr->rootwin, zm_samps, zm_lines, 24) ;
        XPutImage (xinfo_ptr->dpy, pmap_zm, xinfo_ptr->imgGC, ximage_zm, 0, 0, 0, 0,
                zm_samps, zm_lines) ;
        XCopyArea (xinfo_ptr->dpy, pmap_zm, XtWindow (w), xinfo_ptr->imgGC,
               0, 0, zm_samps, zm_lines, 0, 0) ;
        XDestroyImage (ximage_zm) ;
 
}                                                                                                                      
void CDispShort::expose_dazm (Widget w, XtPointer xinfoeq, void *cbs)
{
        CDispShort *thisptr = (CDispShort *) xinfoeq ;
        thisptr->expose_zm (w, xinfoeq, cbs) ;
}                                                                                                                      
void  CDispShort::click (Widget w, XtPointer xinfoeq, void *cbs)
{
        char cursbuf [80] ;
        int    xloc, yloc ;
        int    samps, lines ;
	int    xbuffer, ybuffer ;
        XmDrawingAreaCallbackStruct *dcbs ;

	int value[1];

        dcbs = (XmDrawingAreaCallbackStruct *) cbs ;
        XEvent  *event =  dcbs->event ;
        xloc = event->xbutton.x ;
        yloc = event->xbutton.y ;

        samps = ns ;
        lines = nl ;

        if (event->xany.type==ButtonPress) return ;

        // cout << "xloc  yloc : " << xloc << "  " << yloc << endl ;
        fseek (cdispmaginputfile, yloc*samps*2+xloc*2, SEEK_SET);
        fread (value,2,sizeof(unsigned char),cdispmaginputfile);
	//        fseek ( cdispinputfile, yloc*samps+xloc, SEEK_SET);
	//        fread (bvalue,1,1,cdispinputfile);

	printf ("xloc  yloc : %d %d, Magnitude: %d\n",xloc,yloc, value[0]);
	sprintf (cursbuf, "X, Y :  %5d  %5d   Magnitude: %d", xloc, yloc, value[0]) ;
        XmTextSetString (xinfo_ptr->curswin, cursbuf) ;
        XtVaGetValues (da_zm, XmNwidth, &zm_samps, XmNheight, &zm_lines, NULL) ;
        xstart = xloc - zm_samps / zm_fac / 2 ;
        ystart = yloc - zm_samps / zm_fac / 2 ;
	xbuffer = zm_samps / zm_fac  ; 
	ybuffer = zm_lines / zm_fac  ; 
	xstart = (xstart<0) ? 0:xstart ;
        xstart = (xstart>ns - xbuffer-1) ? ns - xbuffer-1 : xstart ;
        ystart = (ystart<0) ? 0:ystart ;
        ystart = (ystart>nl - ybuffer-1) ? nl - ybuffer-1 : ystart ; 
	XClearArea (xinfo_ptr->dpy, XtWindow (da_zm), 0, 0, 0, 0, True) ;
}

void CDispShort::click_da (Widget w, XtPointer xinfoeq, void *cbs)
{
        CDispShort *thisptr = (CDispShort *) xinfoeq ;
        thisptr->click (w, xinfoeq, cbs) ;
}

