#include "CStats.h"
#include <math.h>
#include <iostream>

using namespace std;

template <class k> 
long tstats (k *indat, long npix, float minvalid, float maxvalid, double *meanval, double *minval, double *maxval, double *stdev) 
{
	long 	ipix, valcount = 0 ;
	k	*iptr ;
	double 	val, total=0, min=1.E12, max=-1.E12 ;
	

	// first calculate the min, max, and mean
	for (ipix=0; ipix<npix ; ipix++) 
	{
		iptr = indat + ipix ;
		val = *iptr ;
		if (val > maxvalid || val < minvalid) continue ;
		valcount++ ;
		if (val > max) max = val ;
		if (val < min) min = val ;
		total += val ;
	}
	*meanval = total / (double) valcount ;
	total = 0. ;
	*minval = min ;
	*maxval = max ;

	// get the std deviation
	for (ipix=0; ipix<npix ; ipix++) 
	{
		iptr = indat + ipix ;
		val = *iptr ;
		if (val > maxvalid || val < minvalid) continue ;
		total += (val - *meanval) * (val - *meanval) ; 
	}
	*stdev = total / double (valcount - 1) ;
	*stdev = sqrt (*stdev) ;
	return (valcount) ;
} 
		
		
		

CStats::CStats () {
	npix = 0 ;
	dtarr = NULL ;
	histo = NULL ;
	meanval = -999 ;
	stdev = -999 ;
	min = -999 ;
	max = -999 ;
	median = -999 ;
}

CStats::CStats (unsigned char *data, long npx, int dt) 
{
	npix = npx ;
	dtarr = data ;
	dtype = dt ;
}

long CStats::SummaryStats () 
{

	float minvalid=-9.E9, maxvalid=9.E9 ;
	// get the summary statistics for the array 
	if (dtype==0) 
	valcount = tstats (dtarr, npix, -9.E9, 9E9, &meanval, &min, &max, &stdev) ;
	if (dtype==1) 
	valcount = tstats ((short int *)dtarr, npix, minvalid, maxvalid, &meanval, &min, &max, &stdev) ;
	if (dtype==2) 
	valcount = tstats ((int *)dtarr, npix, minvalid, maxvalid, &meanval, &min, &max, &stdev) ;
	if (dtype==3) 
	valcount = tstats ((float *)dtarr, npix, minvalid, maxvalid, &meanval, &min, &max, &stdev) ;
	
	return valcount ;
	
	
}

long CStats::SummaryStats (float minvalid, float maxvalid) 
{

	// get the summary statistics for the array 
	if (dtype==0) 
	valcount = tstats (dtarr, npix, minvalid, maxvalid, &meanval, &min, &max, &stdev) ;
	if (dtype==1) 
	valcount = tstats ((short int *)dtarr, npix, minvalid, maxvalid, &meanval, &min, &max, &stdev) ;
	if (dtype==2) 
	valcount = tstats ((int *)dtarr, npix, minvalid, maxvalid, &meanval, &min, &max, &stdev) ;
	if (dtype==3) 
	valcount = tstats ((float *)dtarr, npix, minvalid, maxvalid, &meanval, &min, &max, &stdev) ;
	
	return valcount ;
	
}

int CStats::Report () 
{
	cout << "Mean value    : " << meanval << endl ;
	cout << "Minimum value : " << min << endl ;
	cout << "Maximum value : " << max << endl ;
	cout << "Standard dev  : " << stdev << endl ;
	cout << "Valid pixels  : " << valcount << endl ;
	return (1) ;
}
	 



