#include "XInfo.h"
#include "CDisp.h"
#include "CDispMag.h"
#include "CGetData.h"
#include "CStats.h"
#include <string.h>
#include <stdlib.h>

XInfo *xinfo ;
CDispMag *cdi ;
CGetData *cgd ;

using namespace std;

int main (int argc, char *argv[]) 
{
	char     infile [240] ;
	int 	 status, dtype=0, ns=5120, nl=0, startl=0, flipflag=0 ;
	float    scale=1.;
	long 	 npix ;

	if (argc < 4) {
		cout << "Usage : disany infile dtype nsamps <startl=0> <nlines> <scale=1> <flipflag=0>" << endl ;
		cout << "   For dtype: 0=byte (int8), 1=int16, 2=int32, 3=float32" << endl ;
		return (1) ;
	              }
	argc--;
	strcpy (infile, *++argv) ;
	argc-- ;
	if (argc) {
		dtype = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) 
	{
		ns=atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		startl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		nl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		scale = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		flipflag = atoi (*++argv) ;
		argc-- ;
	}

	xinfo = new XInfo (argc, argv) ;
	cdi = new CDispMag (xinfo->toplevel, infile, xinfo) ;
	cgd = new CGetData ;
	cgd->setparams (infile, ns, startl, nl) ;
	cgd->getarrayRaw (dtype) ;
        npix = long (ns) * cgd->nlines ;
        CStats *cst = new CStats (cgd->raw, npix, dtype) ;
        cst->SummaryStats() ;
	cgd->Raw2Mag (dtype, cst->min, 2./scale*(cst->stdev), flipflag) ;
	cgd->DeleteRaw() ;
	cdi->LoadArray (cgd->mag, cgd->nsamps, cgd->nlines) ;
	cgd->DeleteMag() ;
	cdi->StartDisp () ;

        cst->Report () ;
        cgd->DeleteRaw () ;

	status = xinfo->startloop() ;
	return (0) ;
}


 
void closeup_fb (Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
	delete cdi ;
	delete cgd ;
   	delete xinfo ;
	exit (0) ;   
     
    
 
}      
