#include "XInfo.h"
#include "CDisp.h"
#include "CDispMag.h"
#include "CGetData.h"
#include <string.h>
#include <stdlib.h>

using namespace std;

XInfo *xinfo ;
CDispMag *cdi ;
CGetData *cgd ;



int main (int argc, char *argv[]) 
{
	char     infile [240] ;
	int 	 status, dtype=0, ns=5120, nl=0, startl=0, flipflag=0 ;
	float	 minval=0., maxval=255. ;

	if (argc < 6) {
		cout << "Usage : disany_mnx infile dtype nsamps minval maxval <startl=0> <nlines> <flipflag=0>" << endl ;
		return (1) ;
	}
	argc--;
	strcpy (infile, *++argv) ;
	argc-- ;
	if (argc) {
		dtype = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) 
	{
		ns=atoi (*++argv) ;
		argc-- ;
	}
	if (argc) 
	{
		minval=atof (*++argv) ;
		argc-- ;
	}
	if (argc) 
	{
		maxval=atof (*++argv) ;
		argc-- ;
	}
	
	if (argc) {
		startl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		nl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		flipflag = atoi (*++argv) ;
		argc-- ;
	}

	xinfo = new XInfo (argc, argv) ;
	cdi = new CDispMag (xinfo->toplevel, infile, xinfo) ;
	cgd = new CGetData ;
	cgd->setparams (infile, ns, startl, nl) ;
	cgd->getarrayMag(dtype, minval, maxval, flipflag) ;
	cdi->LoadArray (cgd->mag, cgd->nsamps, cgd->nlines) ;
	cgd->DeleteMag() ;
	cdi->StartDisp () ;


	status = xinfo->startloop() ;
	return (0) ;
}


 
void closeup_fb (Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
	delete cdi ;
	delete cgd ;
   	delete xinfo ;
	exit (0) ;   
     
    
 
}      
