#include "XInfo.h"
#include "CDisp.h"
#include "CDispHgt.h"
#include "CGetData.h"
#include <string.h>
#include <stdlib.h>

using namespace std;

XInfo *xinfo ;
CDispHgt *cdi ;
CGetData *cdg ;


int main (int argc, char *argv[]) 
{
	char     infile [240] ;
	int 	 ns=5120, nl=0, startl=0, flipflag=0, expflag=0;
	float 	 scalefac = 1. , expval = 1. , contint = 100;

	if (argc < 3) {
		cout << "Usage : dishgt infile nsamps <startl=0> <nlines> <contour_interval=100> <scalefac=1.> <expval=1.> <flipflag=0> " << endl ;
		return (1) ;
	}
	argc--;
	strcpy (infile, *++argv) ;
	argc-- ;
	if (argc) 
	{
		ns=atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		startl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		nl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		contint = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		scalefac = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		expflag = 1 ;
		expval = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		flipflag = atoi (*++argv) ;
		argc-- ;
	}

	xinfo = new XInfo (argc, argv) ;
	cdi = new CDispHgt (xinfo->toplevel, infile, xinfo) ;
	cdg = new CGetData ;
	cdg->setparams (infile, ns, startl, nl) ;
	cdg->getarrayHgt (scalefac, expflag, expval, contint, flipflag) ;
	cdi->WriteArrays (cdg->mag, cdg->hgt, cdg->nsamps, cdg->nlines) ;
	cdg->DeleteHgt () ;
	//cdi->StartDisp () ;
	//status = xinfo->startloop() ;
	return (0) ;
}


 
void closeup_fb (Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
	delete cdi ;
	delete cdg ;
   	delete xinfo ;
	exit (0) ;   
     
    
 
}      
