#include "XInfo.h"
#include "CDisp.h"
#include "CDispMag.h"
#include "CGetData.h"
#include <string.h>
#include <stdlib.h>

using namespace std;

XInfo *xinfo ;
CDispMag *cdi ;
CGetData *cdg ;


int main (int argc, char *argv[]) 
{
	char     infile [240] ;
	int 	 ns=1024, nl=0, startl=0, flipflag=0, fifthflag=0 ;
	int 	 expflag=1 ;
	float 	 expval = 0.3, scale=1.0 ;

	if (argc < 3) {
		cout << "Usage : dismag infile nsamps <startl=0> <nlines> <scale=1.0> <expval=0.3> <flipflag=0>" << endl ;
		return (1) ;
	}
	argc--;
	strcpy (infile, *++argv) ;
	argc-- ;
	if (argc) 
	{
		ns=atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		startl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		nl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		scale = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		expflag = 1 ;
		expval = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		flipflag = atoi (*++argv) ;
		argc-- ;
	}

	xinfo = new XInfo (argc, argv) ;
	cdi = new CDispMag (xinfo->toplevel, infile, xinfo) ;
	cdg = new CGetData ;
	cdg->setparams (infile, ns, startl, nl) ;
	cdg->getarrayMag (scale, expflag, expval, flipflag, fifthflag) ;
	cdi->WriteArray (cdg->mag, cdg->nsamps, cdg->nlines) ;
	cdg->DeleteMag() ;
	//cdi->StartDisp () ;
	//status = xinfo->startloop() ;
	return (0) ;
}


 
void closeup_fb (Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
	delete cdi ;
	delete cdg ;
   	delete xinfo ;
	exit (0) ;   
     
    
 
}      
