#include "XInfo.h"
#include "CDisp.h"
#include "CDispRG.h"
#include "CGetData.h"
#include <string.h>
#include <stdlib.h>

using namespace std;

XInfo *xinfo ;
CDispRG *cdi ;
CGetData *cdg ;


int main (int argc, char *argv[]) 
{
	char     infile [240] ;
	int 	 status, ns=5120, nl=0, startl=0, flipflag=0 ;
	int 	 expflag=0 ;
	float 	 scalefac = 1., expval = 0.5 ;

	if (argc < 2) {
		cout << "Usage : disprg infile <nsamps=5120> <startl=0> <nlines> <scalefac = 1.> <expval=0.5> <flipflag=0>" << endl ;
		return (1) ;
	}
	argc--;
	cout << "number of arguments : " << argc << endl ;
	strcpy (infile, *++argv) ;
	argc-- ;
	if (argc) 
	{
		ns=atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		startl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		nl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
	  scalefac = atof (*++argv) ;
	  argc-- ;
	}
	if (argc) {
		expflag = 1 ;
		expval = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		flipflag = atoi(*++argv) ;
		argc-- ;
	}

	xinfo = new XInfo (argc, argv) ;
	cdi = new CDispRG (xinfo->toplevel, infile, xinfo) ;
	cdg = new CGetData ;
	cdg->setparams (infile, ns, startl, nl) ;
	cdg->getarrayRG (scalefac, expflag, expval, flipflag) ;
	cdi->LoadArrays (cdg->red, cdg->grn, cdg->nsamps, cdg->nlines) ;
	cdg->DeleteRG() ;
	cdi->StartDisp () ;
	status = xinfo->startloop() ;
	return (0) ;
}


 
void closeup_fb (Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
	delete cdi ;
	delete cdg ;
   	delete xinfo ;
	exit (0) ;   
     
    
 
}      
