#include "XInfo.h"
#include "CDisp.h"
#include "CDispShort.h"
#include "CGetData.h"
#include "CStats.h"
#include <string.h>
#include <stdlib.h>

XInfo *xinfo ;
CDispShort *cdi ;
CGetData *cgd ;

using namespace std;

int main (int argc, char *argv[]) 
{
	char     infile [240] ;
	int 	 status, ns=5120, nl=0, startl=0, flipflag=0 ;
	float    minval = 0., maxval=10000.;

	if (argc < 3) {
		cout << "Usage : disshort infile nsamps <startl=0> <nlines> <min_val=0> <max_val=10000> <flipflag=0>" << endl ;
		return (1) ;
	              }
	argc--;
	strcpy (infile, *++argv) ;
	argc-- ;
	if (argc) 
	{
		ns=atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		startl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		nl = atoi (*++argv) ;
		argc-- ;
	}
	if (argc) {
		minval = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		maxval = atof (*++argv) ;
		argc-- ;
	}
	if (argc) {
		flipflag = atoi (*++argv) ;
		argc-- ;
	}

	xinfo = new XInfo (argc, argv) ;
	cdi = new CDispShort (xinfo->toplevel, infile, xinfo) ;
	cgd = new CGetData ;
	cgd->setparams (infile, ns, startl, nl) ;
	cgd->getarrayRaw (1) ; /* 16 bit integers */
	cgd->Raw2Mag (1, minval, (maxval-minval), flipflag) ;
	cgd->DeleteRaw() ;
	cdi->LoadArray (cgd->mag, cgd->nsamps, cgd->nlines) ;
	cgd->DeleteMag() ;
	cdi->StartDisp () ;
        cgd->DeleteRaw () ;

	status = xinfo->startloop() ;
	return (0) ;
}


 
void closeup_fb (Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
	delete cdi ;
	delete cgd ;
   	delete xinfo ;
	exit (0) ;   
     
    
 
}      
