% generate A and b with an approximate analytic center x
if (iter == 0)
    [m,n]  = size(A);
    x=ones(n,1);
    b=A*x;
end;
% Apply the (primal) Newton method to update the center x
Ak     = A*diag(x);
yk     = -Ak'\ones(n,1);
sk     = -A'*yk;
pk     = x.*sk-ones(n,1);
normpk = norm(pk)
y      = yk;
s      = sk;
if (normpk < 1)
    x  = x-x.*pk;
else
    x  = x-(0.5/normpk)*(x.*pk);
end;
iter   =iter + 1;
% This is an implementation of the (primal) Newton method
% to compute the analytic center of {x :   Ax=b, x >=0 }


