[m,n]=size(A);
gap=n;
iter=0;
S       = C-A'*diag(y)*A;
while gap > 1.e-5,
iter=iter+1
%
%  Compute and factorize slack matrix S for updating
%  
R       = chol(S);
R       = inv(R);
B       = A*R;
M       = B*B';
diagM   = diag(M);
% 
%  Compute the scaled gradient
%
grad    = ((n/gap)*b-diagM)./(abs(y)+0.1*ones(m,1));
maxg    = max(abs(grad));
[IS]    = find(max(0,abs(grad)-maxg/10));
size(IS)
(M(IS,IS).*M(IS,IS))\[b(IS) diagM(IS)];
%(M.*M)\[b(IS) diagM];
dy1     = ans(:,1); dy2=ans(:,2);
dy      = (n/gap)*dy1-dy2;
%
%  Compute the norm of direction for slack matrix S
%
normpk  = sqrt(dy'*((n/gap)*b(IS)-diagM(IS)));
while normpk < 1, 
  gap    = gap/3;
  dy     = (n/gap)*dy1-dy2;
  normpk = sqrt(dy'*((n/gap)*b(IS)-diagM(IS)));
end;
%
%  Update the dual solution
%
%normpk = normpk 
%y(IS)  = y(IS)+(0.7/normpk)*dy;
y(IS)  = y(IS)+(0.7/normpk)*dy;
%
% Update the primal solution and the rest Lagrange variables
%
ddy   = zeros(m,1);
ddy(IS)=dy;
X     = (gap/n)*(R*(eye(n)+B'*diag(ddy)*B)*R');
%dy    = b-diag(A*X*A');
%dy    = (gap/n)*(norm(ddy)/norm(dy))*dy;
%beta  =.1;
%small = -1;
%while small <= 1.e-5
%beta  = beta/10;
%yy    = y+beta*dy;
%S     = C-A'*diag(yy)*A;
%small = eigs(S,1,'SR');
%end;
%y     = yy;
S     = C-A'*diag(y)*A;
end;
%
%  This the dual barrier method for solving dual SDP:
%
%      maximize    b^T*y
%      subject to  A^T*y <= C, 
%
%  Input 
%      A_i=a_ia_i^T in standard primal form, i=1,...,m
%      A'  =[a_1, a_2, ..., a_m]
%      b: constraint right-hand column vector
%      C: objective symmetric matrix
%      y: interior feasible point
%
%  Output
%      X: primal solution
%      (y,S): dual solution
%  different way to compute the norm pk.


