if (iter == 0)
    [m,n]  = size(A);
    x=x0;
    y=y0;
    s=c-A'*y;
end;
if exist('toler') ~= 1
   toler = 1.e-6;
end;
if exist('alpha') ~= 1
   alpha = 0.995;
end;
if exist('rho') ~= 1
   rho = 5*n;
end;
potential=(n+rho)*log(x'*s)-ones(n,1)'*log(x.*s)
mu     = x'*s/n;
gamma  = n/(n+rho);
rk     = gamma*mu*ones(n,1)-x.*s;
Ak     = A*diag(x./s);
Mk     = Ak*A';
dy     = -Mk\(A*(rk./s));
ds     = -A'*dy;
dx     = rk./s - (x.*ds)./s;
% Conservative step size
%theta  = min(x.*s)/((rk./x)'*(rk./s));
%theta  = alpha*sqrt(theta);
%
% Aggressive step size
theta  = min([dx./x;ds./s]);
theta = abs(alpha/theta);
%
y      = y+theta*dy;
s      = s+theta*ds;
x      = x+theta*dx;
potential=(n+rho)*log(x'*s)-ones(n,1)'*log(x.*s)
iter   = iter+1
%
%  This is one iteration demo of the primal-dual potential reduction algorithm
%  for solving LP:
%
%      maximize    c'*x
%      subject to  A x = b, x >= 0
%
%  Input 
%      A: m x n matrix
%      iter (= 0): iteration count
%      rho: potential parameter; between sqrt(n) to n
%      alpha: step-size
