%
%  This program solves the linearly constrained programming.
%
%      min   \|x\|_{.5}^{.5}:=\sum x_j^{.5}
%      s.t.  Ax = b, x >= 0.
%
%  Input 
%      x0: interior (positive) primal feasile solution
%      A: Sparse constraint matrix.
%      toler: relative stopping tolerance: the objective value close to 
%             the optimal one in the range of tolerance. 
%             Default value: 1.e-6.
%      alpha: step size: alpha > 0. Default value: .95
%     
%  Output
%     x>=0  : primal solution: Ax = b,
%     y     : Lagrange (dual) solution, where
%             \|X(nabla f(x) - A^Ty)\| =< toler
%  
%  How to call the solver: type "pnormmin" and return.
%
 [m,n]=size(A);
 x  = x0;
 gap=1;
 iter=0;
 alpha=0.95;
 toler=1.e-6;
%
%  Repeatly solving the affine scaling direction problem
%
 while (gap >= toler) & (iter < 101),
   % generate affine direction
   gg = -sqrt(x);
   DD = sparse(1:n,1:n,x,n,n);
   AD = A*DD;
   y = [speye(n) AD';AD sparse(m,m)]\[gg;sparse(m,1)];
   dd = y(1:n);
   y = y(n+1:n+m);
   gap=norm(dd);
   iter=iter+1;
   % compute step size
   nora = min(dd);
   nora = abs(alpha/nora);
   %
   % Update iterates
   %
   dd=x.*dd;
   x = x + nora*dd;
 end;
 iter
 % end