//--------------------------------------------------------------------------
// Tania Morimoto and Allison Okamura, Stanford University
// 11.16.13
// Code to test basic Hapkit functionality (sensing and force output)
//--------------------------------------------------------------------------

// Includes
#include <math.h>

// Pin declares
int pwmPin = 5; // PWM output pin for motor 1
int dirPin = 8; // direction output pin for motor 1
int sensorPosPin = A2; // input pin for MR sensor
int fsrPin = A3; // input pin for FSR sensor
const int buttonPin = 2; //button analog pin

// Position tracking variables
int buttonState = 0;    // keeps track of Button 
int updatedPos = 0;     // keeps track of the latest updated value of the MR sensor reading
int rawPos = 0;         // current raw reading from MR sensor
int lastRawPos = 0;     // last raw reading from MR sensor
int lastLastRawPos = 0; // last last raw reading from MR sensor
int flipNumber = 0;     // keeps track of the number of flips over the 180deg mark
int tempOffset = 0;
int rawDiff = 0;
int lastRawDiff = 0;
int rawOffset = 0;
int lastRawOffset = 0;
const int flipThresh = 700;  // threshold to determine whether or not a flip over the 180 degree mark occurred
boolean flipped = false;

// Kinematics Variables
double a = 0;           // position of the handle [m]
double lasta = 0; //last x position of the handle
double va = 0; //velocity of the handle
double lastVa = 0; //last velocity of the handle
double lastLastVa = 0; //last last velocity of the handle

// Force output variables
double force = 0;           // force at the handle
double Tp = 0;              // torque of the motor pulley
double duty = 0;            // duty cylce (between 0 and 255)
unsigned int output = 0;    // output command to the motor

// --------------------------------------------------------------
// Setup function -- NO NEED TO EDIT
// --------------------------------------------------------------
void setup() 
{
  // Set up serial communication
  Serial.begin(19200);
  
  // Set PWM frequency 
  setPwmFrequency(pwmPin,1); 
  
  // Input pins
  pinMode(sensorPosPin, INPUT); // set MR sensor pin to be an input
  pinMode(fsrPin, INPUT);       // set FSR sensor pin to be an input
  pinMode(buttonPin, INPUT);

  // Output pins
  pinMode(pwmPin, OUTPUT);  // PWM pin for motor A
  pinMode(dirPin, OUTPUT);  // dir pin for motor A
  
  // Initialize motor 
  analogWrite(pwmPin, 0);     // set to not be spinning (0/255)
  digitalWrite(dirPin, LOW);  // set direction
  
  // Initialize position valiables
  lastLastRawPos = analogRead(sensorPosPin);
  lastRawPos = analogRead(sensorPosPin);
}


// --------------------------------------------------------------
// Main Loop
// --------------------------------------------------------------
void loop()
{
  //*************************************************************
  //*** Section 1. Compute position in counts (do not change) ***  
  //*************************************************************

buttonState= digitalRead(buttonPin); // sets up reading of button pin function

  // Get voltage output by MR sensor
  rawPos = analogRead(sensorPosPin);  //current raw position from MR sensor

  // Calculate differences between subsequent MR sensor readings
  rawDiff = rawPos - lastRawPos;          //difference btwn current raw position and last raw position
  lastRawDiff = rawPos - lastLastRawPos;  //difference btwn current raw position and last last raw position
  rawOffset = abs(rawDiff);
  lastRawOffset = abs(lastRawDiff);
  
  // Update position record-keeping vairables
  lastLastRawPos = lastRawPos;
  lastRawPos = rawPos;
  
  // Keep track of flips over 180 degrees
  if((lastRawOffset > flipThresh) && (!flipped)) { // enter this anytime the last offset is greater than the flip threshold AND it has not just flipped
    if(lastRawDiff > 0) {        // check to see which direction the drive wheel was turning
      flipNumber--;              // cw rotation 
    } else {                     // if(rawDiff < 0)
      flipNumber++;              // ccw rotation
    }
    if(rawOffset > flipThresh) { // check to see if the data was good and the most current offset is above the threshold
      updatedPos = rawPos + flipNumber*rawOffset; // update the pos value to account for flips over 180deg using the most current offset 
      tempOffset = rawOffset;
    } else {                     // in this case there was a blip in the data and we want to use lastactualOffset instead
      updatedPos = rawPos + flipNumber*lastRawOffset;  // update the pos value to account for any flips over 180deg using the LAST offset
      tempOffset = lastRawOffset;
    }
    flipped = true;            // set boolean so that the next time through the loop won't trigger a flip
  } else {                        // anytime no flip has occurred
    updatedPos = rawPos + flipNumber*tempOffset; // need to update pos based on what most recent offset is 
    flipped = false;
  }
 
  //*************************************************************
  //*** Section 2. Compute position in meters *******************
  //*************************************************************

  // ADD YOUR CODE HERE
  // Define kinematic parameters you may need
     //double rh = ?;   //[m]
  double rh = .0175;
  double rs = .0165;
  double rp = .005;
  double pi = 3.14;
  // Step 2.1: print updatedPos via serial monitor
  //Serial.println(updatedPos);
  // Step 2.6: double ts = ?; // Compute the angle of the sector pulley (ts) in degrees based on updatedPos
  double ts = (.0623*updatedPos - 16.183)*(pi/180); 
  //Serial.println(ts);
  // Step 2.7: xh = ?;       // Compute the position of the handle (in meters) based on ts (in radians)
  double y = rh*sin(ts+ (pi/2));
  double x = rh*cos(ts+ (pi/2)); 
  float a = sqrt((x*x)-((y-rh)*(y-rh)));
  Serial.println(a,6);
  // Step 2.8: print xh via serial monitor
//  Serial.println(y,6);
  
  //Define Velocity
  va = -(.95*.95)*lastLastVa + 2*.95*lastVa + (1-.95)*(1-.95)*(a-lasta)/.0001; // filtered velocity (2nd order filler)
  lasta = a;
  lastLastVa = lastVa;
  lastVa = va;  
  //*************************************************************
  //*** Section 3. Assign a motor output force in Newtons *******  
  //*************************************************************

  
  //Declare tissue variables
  double k_skin = 150;
  double b_skin = .75;
  double k_vein = 125;
  double k_vein2 = 225;
  double b_withdrawal = .1;
  
 if (va>0) {
   if (a<.0009) {
      force = 0;
    }
      else if (.0009<a && a<.0012 ) { //surface of skin
      force = -k_skin*(a-.0009); //force of skin puncture
    }
      else if (.0012<a && a<.003) { //skin tissue
      force = -k_skin*(a-.0009) + -b_skin*va //force moving through skin tissue
    }
      else if (.003<a && a<.0045) { //vein wall
      force = -k_vein*(a-.003); //force of vein wall puncture
    }
      else if (.0045<a && a<.009) { //inside of vein
      force = .01; //force moving through inside of vein
    }
      else if (.009<a && a<.0105) { //second vein wall
      force = -k_vein2*(a-.009); //force of second vein wall puncture
    }
      else if (.0105<a) { //beyond vein
      force = -b_skin*va; //force moving beyond vein
    }
 } else {
   force = 0;
 }
    
double Tp = (force*rh*rp)/rs;
  //*************************************************************
  //*** Section 4. Compute measured handle force in Newtons *****
  //*************************************************************
 
  // ADD YOUR CODE HERE
  // Step 4.1: int fsrValue = ?; // Read the analog input value from the FSR pin ansd store in the variable fsrValue
  // Step 4.2: print fsrValue via serial monitor
  // Step 4.7: double fsrForce = ?; // Compute the (approximate) FSR measured force value in Newtons, based on calibration
  // Step 4.8: print fsrForce via serial monitor
  
  //*************************************************************
  //*** Section 5. Force output (do not change) *****************
  //*************************************************************
  
  // Determine correct direction for motor torque
  if(force < 0) { 
    digitalWrite(dirPin, HIGH);
  } else {
    digitalWrite(dirPin, LOW);
  }

  // Compute the duty cycle required to generate Tp (torque at the motor pulley)
  duty = sqrt(abs(Tp)/0.0125);

  // Make sure the duty cycle is between 0 and 100%
  if (duty > 1) {            
    duty = 1;
  } else if (duty < 0) { 
    duty = 0;
  }  
  output = (int)(duty* 255);   // convert duty cycle to output signal
  analogWrite(pwmPin,output);  // output the signal
}

// --------------------------------------------------------------
// Function to set PWM Freq -- DO NOT EDIT
// --------------------------------------------------------------
void setPwmFrequency(int pin, int divisor) {
  byte mode;
  if(pin == 5 || pin == 6 || pin == 9 || pin == 10) {
    switch(divisor) {
      case 1: mode = 0x01; break;
      case 8: mode = 0x02; break;
      case 64: mode = 0x03; break;
      case 256: mode = 0x04; break;
      case 1024: mode = 0x05; break;
      default: return;
    }
    if(pin == 5 || pin == 6) {
      TCCR0B = TCCR0B & 0b11111000 | mode;
    } else {
      TCCR1B = TCCR1B & 0b11111000 | mode;
    }
  } else if(pin == 3 || pin == 11) {
    switch(divisor) {
      case 1: mode = 0x01; break;
      case 8: mode = 0x02; break;
      case 32: mode = 0x03; break;
      case 64: mode = 0x04; break;
      case 128: mode = 0x05; break;
      case 256: mode = 0x06; break;
      case 1024: mode = 0x7; break;
      default: return;
    }
    TCCR2B = TCCR2B & 0b11111000 | mode;
  }
}

