clear all;
close all;
clc

IonicEffectFlag = 1;  %IonicStrengthFlag 0 = OFF, 1=ON

%Format 'Species Name', '[valence mobility pka]', concentration (mM)
InputTable={'Imidazole','[  1     52.0e-9       7.15]',0.06;
    'HCl','[-1     79.1e-009       -2]',0.03;
    };

%Example of multivalent species. 
% InputTable={'Imidazole','[  1     52.0e-9       7.15]',0.06;
%     'HCl','[-1     79.1e-009       -2]',0.02;
%     'Ciric Acid','[-3     74.4e-009       6.396] [-2     54.7e-009       4.761] [-1     28.7e-009       3.128]',0.01;
%     };

[pH,SigVec,muMat, cMat, cH, cizCube]=FuncSteadyStateSolver(InputTable, IonicEffectFlag);

fprintf('pH = %g, conductivity = %g (S/m)\n\n', pH, SigVec);
disp('Effective mobilities (m^2/(V.s))');
disp(muMat);
%cizCube: concentrations of species in various ionization states;



